/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonParsableCommandResponse;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.base.WithFeatureId;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.messages.AbstractMessageCommandResponse;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessageCommandResponse;

@JsonParsableCommandResponse(type="messages.responses:featureResponseMessage")
public final class SendFeatureMessageResponse<T>
extends AbstractMessageCommandResponse<T, SendFeatureMessageResponse>
implements WithFeatureId {
    public static final String NAME = "featureResponseMessage";
    public static final String TYPE = "messages.responses:featureResponseMessage";
    private static final JsonFieldDefinition<String> JSON_FEATURE_ID = JsonFactory.newStringFieldDefinition((CharSequence)"featureId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    private final String featureId;

    private SendFeatureMessageResponse(ThingId thingId, String featureId, Message<T> message, HttpStatusCode responseStatusCode, DittoHeaders dittoHeaders) {
        super(TYPE, thingId, message, responseStatusCode, dittoHeaders);
        this.featureId = Objects.requireNonNull(featureId, "The featureId cannot be null.");
    }

    @Override
    public SendFeatureMessageResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return SendFeatureMessageResponse.of(this.getThingEntityId(), this.getFeatureId(), this.getMessage(), this.getStatusCode(), dittoHeaders);
    }

    @Deprecated
    public static <T> SendFeatureMessageResponse<T> of(String thingId, String featureId, Message<T> message, HttpStatusCode responseStatusCode, DittoHeaders dittoHeaders) {
        return SendFeatureMessageResponse.of(ThingId.of((CharSequence)thingId), featureId, message, responseStatusCode, dittoHeaders);
    }

    public static <T> SendFeatureMessageResponse<T> of(ThingId thingId, String featureId, Message<T> message, HttpStatusCode responseStatusCode, DittoHeaders dittoHeaders) {
        return new SendFeatureMessageResponse<T>(thingId, featureId, message, responseStatusCode, dittoHeaders);
    }

    public static <T> SendFeatureMessageResponse<T> fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return SendFeatureMessageResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static <T> SendFeatureMessageResponse<T> fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SendFeatureMessageResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String extractedThingId = (String)jsonObject.getValueOrThrow(MessageCommandResponse.JsonFields.JSON_THING_ID);
            ThingId thingId = ThingId.of((CharSequence)extractedThingId);
            String featureId = (String)jsonObject.getValueOrThrow(JSON_FEATURE_ID);
            Message message = SendFeatureMessageResponse.deserializeMessageFromJson(jsonObject);
            return SendFeatureMessageResponse.of(thingId, featureId, message, statusCode, dittoHeaders);
        });
    }

    public String getFeatureId() {
        return this.featureId;
    }

    @Override
    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        super.appendPayload(jsonObjectBuilder, schemaVersion, predicate);
        jsonObjectBuilder.remove(MessageCommand.JsonFields.JSON_THING_ID);
        JsonObject superBuild = jsonObjectBuilder.build();
        jsonObjectBuilder.removeAll();
        jsonObjectBuilder.set(MessageCommand.JsonFields.JSON_THING_ID, (Object)this.getThingEntityId().toString());
        jsonObjectBuilder.set(JSON_FEATURE_ID, (Object)this.getFeatureId());
        jsonObjectBuilder.setAll((Iterable)superBuild);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.featureId);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SendFeatureMessageResponse that = (SendFeatureMessageResponse)obj;
        return that.canEqual(this) && Objects.equals(this.featureId, that.featureId) && super.equals(that);
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SendFeatureMessageResponse;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", featureId=" + this.featureId + "]";
    }
}

