/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.messages;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableCommand;
import org.eclipse.ditto.model.messages.Message;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.messages.AbstractMessageCommand;
import org.eclipse.ditto.signals.commands.messages.MessageCommand;

@JsonParsableCommand(typePrefix="messages.commands:", name="thingMessage")
@Immutable
public final class SendThingMessage<T>
extends AbstractMessageCommand<T, SendThingMessage> {
    public static final String NAME = "thingMessage";
    public static final String TYPE = "messages.commands:thingMessage";

    private SendThingMessage(ThingId thingId, Message<T> message, DittoHeaders dittoHeaders) {
        super(TYPE, thingId, message, dittoHeaders);
    }

    @Override
    public SendThingMessage setDittoHeaders(DittoHeaders dittoHeaders) {
        return SendThingMessage.of(this.getThingEntityId(), this.getMessage(), dittoHeaders);
    }

    @Deprecated
    public static <T> SendThingMessage<T> of(String thingId, Message<T> message, DittoHeaders dittoHeaders) {
        return SendThingMessage.of(ThingId.of((CharSequence)thingId), message, dittoHeaders);
    }

    public static <T> SendThingMessage<T> of(ThingId thingId, Message<T> message, DittoHeaders dittoHeaders) {
        return new SendThingMessage<T>(thingId, message, dittoHeaders);
    }

    public static <T> SendThingMessage<T> fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return SendThingMessage.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static <T> SendThingMessage<T> fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (SendThingMessage)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String extractedThingId = (String)jsonObject.getValueOrThrow(MessageCommand.JsonFields.JSON_THING_ID);
            ThingId thingId = ThingId.of((CharSequence)extractedThingId);
            Message message = SendThingMessage.deserializeMessageFromJson(jsonObject);
            return SendThingMessage.of(thingId, message, dittoHeaders);
        });
    }

    @Override
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SendThingMessage;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + "]";
    }
}

