/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.exceptions.DittoJsonException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.ErrorResponse;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyErrorRegistry;

@Immutable
public final class PolicyErrorResponse
extends AbstractCommandResponse<PolicyErrorResponse>
implements PolicyCommandResponse<PolicyErrorResponse>,
ErrorResponse<PolicyErrorResponse> {
    public static final String TYPE = "policies.responses:errorResponse";
    private static final PolicyErrorRegistry POLICY_ERROR_REGISTRY = PolicyErrorRegistry.newInstance();
    private final String policyId;
    private final DittoRuntimeException dittoRuntimeException;

    private PolicyErrorResponse(String policyId, DittoRuntimeException dittoRuntimeException, DittoHeaders dittoHeaders) {
        super(TYPE, dittoRuntimeException.getStatusCode(), dittoHeaders);
        this.policyId = Objects.requireNonNull(policyId, "Policy ID");
        this.dittoRuntimeException = Objects.requireNonNull(dittoRuntimeException, "The Ditto Runtime Exception must not be null");
    }

    public static PolicyErrorResponse of(DittoRuntimeException dittoRuntimeException) {
        return PolicyErrorResponse.of("unknown:unknown", dittoRuntimeException, dittoRuntimeException.getDittoHeaders());
    }

    public static PolicyErrorResponse of(String policyId, DittoRuntimeException dittoRuntimeException) {
        return new PolicyErrorResponse(policyId, dittoRuntimeException, dittoRuntimeException.getDittoHeaders());
    }

    public static PolicyErrorResponse of(DittoRuntimeException dittoRuntimeException, DittoHeaders dittoHeaders) {
        return PolicyErrorResponse.of("unknown:unknown", dittoRuntimeException, dittoHeaders);
    }

    public static PolicyErrorResponse of(String policyId, DittoRuntimeException dittoRuntimeException, DittoHeaders dittoHeaders) {
        return new PolicyErrorResponse(policyId, dittoRuntimeException, dittoHeaders);
    }

    public static PolicyErrorResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        JsonObject jsonObject = (JsonObject)DittoJsonException.wrapJsonRuntimeException(() -> JsonFactory.newObject((String)jsonString));
        return PolicyErrorResponse.fromJson(jsonObject, dittoHeaders);
    }

    public static PolicyErrorResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
        JsonObject payload = ((JsonValue)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.PAYLOAD)).asObject();
        DittoRuntimeException exception = (DittoRuntimeException)POLICY_ERROR_REGISTRY.parse(payload, dittoHeaders);
        return PolicyErrorResponse.of(policyId, exception, dittoHeaders);
    }

    public String getId() {
        return this.policyId;
    }

    public DittoRuntimeException getDittoRuntimeException() {
        return this.dittoRuntimeException;
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.PAYLOAD, (Object)this.dittoRuntimeException.toJson(schemaVersion, thePredicate), predicate);
    }

    @Override
    public PolicyErrorResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return PolicyErrorResponse.of(this.policyId, this.dittoRuntimeException, dittoHeaders);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolicyErrorResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyErrorResponse that = (PolicyErrorResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.dittoRuntimeException, that.dittoRuntimeException) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.dittoRuntimeException);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", dittoRuntimeException=" + this.dittoRuntimeException + "]";
    }
}

