/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.signals.commands.base.AbstractCommandToExceptionRegistry;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyEntryNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourceNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourcesNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectsNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.query.RetrievePolicyEntry;
import org.eclipse.ditto.signals.commands.policies.query.RetrieveSubject;
import org.eclipse.ditto.signals.commands.policies.query.RetrieveSubjects;

public final class PolicyCommandToAccessExceptionRegistry
extends AbstractCommandToExceptionRegistry<PolicyCommand, DittoRuntimeException> {
    private static final PolicyCommandToAccessExceptionRegistry INSTANCE = PolicyCommandToAccessExceptionRegistry.createInstance();

    private PolicyCommandToAccessExceptionRegistry(Map<String, Function<PolicyCommand, DittoRuntimeException>> mappingStrategies) {
        super(mappingStrategies);
    }

    public static PolicyCommandToAccessExceptionRegistry getInstance() {
        return INSTANCE;
    }

    private static PolicyCommandToAccessExceptionRegistry createInstance() {
        HashMap<String, Function<PolicyCommand, DittoRuntimeException>> mappingStrategies = new HashMap<String, Function<PolicyCommand, DittoRuntimeException>>();
        mappingStrategies.put("policies.commands:retrievePolicy", command -> (PolicyNotAccessibleException)PolicyNotAccessibleException.newBuilder(command.getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:retrievePolicyEntries", command -> (PolicyNotAccessibleException)PolicyNotAccessibleException.newBuilder(command.getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:retrievePolicyEntry", command -> (PolicyEntryNotAccessibleException)PolicyEntryNotAccessibleException.newBuilder(command.getId(), (CharSequence)((RetrievePolicyEntry)command).getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:retrieveResource", command -> (ResourceNotAccessibleException)ResourceNotAccessibleException.newBuilder(command.getId(), (CharSequence)((RetrievePolicyEntry)command).getLabel(), command.getResourcePath().toString()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:retrieveResources", command -> (ResourcesNotAccessibleException)ResourcesNotAccessibleException.newBuilder(command.getId(), (CharSequence)((RetrievePolicyEntry)command).getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:retrieveSubject", command -> (SubjectNotAccessibleException)SubjectNotAccessibleException.newBuilder(command.getId(), (CharSequence)((RetrieveSubject)command).getLabel(), (CharSequence)((RetrieveSubject)command).getSubjectId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:retrieveSubjects", command -> (SubjectsNotAccessibleException)SubjectsNotAccessibleException.newBuilder(command.getId(), (CharSequence)((RetrieveSubjects)command).getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        return new PolicyCommandToAccessExceptionRegistry(mappingStrategies);
    }
}

