/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.signals.commands.base.AbstractCommandToExceptionRegistry;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyEntryNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourceNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourcesNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectsNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.modify.DeletePolicyEntry;
import org.eclipse.ditto.signals.commands.policies.modify.DeleteResource;
import org.eclipse.ditto.signals.commands.policies.modify.DeleteSubject;
import org.eclipse.ditto.signals.commands.policies.modify.ModifyPolicyEntry;
import org.eclipse.ditto.signals.commands.policies.modify.ModifyResource;
import org.eclipse.ditto.signals.commands.policies.modify.ModifyResources;
import org.eclipse.ditto.signals.commands.policies.modify.ModifySubject;
import org.eclipse.ditto.signals.commands.policies.modify.ModifySubjects;

public final class PolicyCommandToModifyExceptionRegistry
extends AbstractCommandToExceptionRegistry<PolicyCommand, DittoRuntimeException> {
    private static final PolicyCommandToModifyExceptionRegistry INSTANCE = PolicyCommandToModifyExceptionRegistry.createInstance();

    private PolicyCommandToModifyExceptionRegistry(Map<String, Function<PolicyCommand, DittoRuntimeException>> mappingStrategies) {
        super(mappingStrategies);
    }

    public static PolicyCommandToModifyExceptionRegistry getInstance() {
        return INSTANCE;
    }

    private static PolicyCommandToModifyExceptionRegistry createInstance() {
        HashMap<String, Function<PolicyCommand, DittoRuntimeException>> mappingStrategies = new HashMap<String, Function<PolicyCommand, DittoRuntimeException>>();
        mappingStrategies.put("policies.commands:deletePolicy", command -> (PolicyNotModifiableException)PolicyNotModifiableException.newBuilder(command.getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:deletePolicyEntry", command -> (PolicyEntryNotModifiableException)PolicyEntryNotModifiableException.newBuilder(command.getId(), (CharSequence)((DeletePolicyEntry)command).getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:deleteResource", command -> (ResourceNotModifiableException)ResourceNotModifiableException.newBuilder(command.getId(), (CharSequence)((DeleteResource)command).getLabel(), command.getResourcePath().toString()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:deleteSubject", command -> (SubjectNotModifiableException)SubjectNotModifiableException.newBuilder(command.getId(), (CharSequence)((DeleteSubject)command).getLabel(), (CharSequence)((DeleteSubject)command).getSubjectId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:createPolicy", command -> (PolicyNotAccessibleException)PolicyNotAccessibleException.newBuilder(command.getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifyPolicy", command -> (PolicyNotModifiableException)PolicyNotModifiableException.newBuilder(command.getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifyPolicyEntries", command -> (PolicyNotModifiableException)PolicyNotModifiableException.newBuilder(command.getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifyPolicyEntry", command -> (PolicyEntryNotModifiableException)PolicyEntryNotModifiableException.newBuilder(command.getId(), (CharSequence)((ModifyPolicyEntry)command).getPolicyEntry().getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifyResource", command -> (ResourceNotModifiableException)ResourceNotModifiableException.newBuilder(command.getId(), (CharSequence)((ModifyResource)command).getLabel(), command.getResourcePath().toString()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifyResources", command -> (ResourcesNotModifiableException)ResourcesNotModifiableException.newBuilder(command.getId(), (CharSequence)((ModifyResources)command).getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifySubject", command -> (SubjectNotModifiableException)SubjectNotModifiableException.newBuilder(command.getId(), (CharSequence)((ModifySubject)command).getLabel(), (CharSequence)((ModifySubject)command).getSubject().getId()).dittoHeaders(command.getDittoHeaders()).build());
        mappingStrategies.put("policies.commands:modifySubjects", command -> (SubjectsNotModifiableException)SubjectsNotModifiableException.newBuilder(command.getId(), (CharSequence)((ModifySubjects)command).getLabel()).dittoHeaders(command.getDittoHeaders()).build());
        return new PolicyCommandToModifyExceptionRegistry(mappingStrategies);
    }
}

