/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyConflictException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.conflict";
    private static final String MESSAGE_TEMPLATE = "The Policy with ID ''{0}'' already exists";
    private static final String DEFAULT_DESCRIPTION = "Choose another Policy ID";
    private static final long serialVersionUID = 4742964538205322837L;

    private PolicyConflictException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.CONFLICT, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId) {
        return new Builder(policyId);
    }

    public static PolicyConflictException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyConflictException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static PolicyConflictException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyConflictException.fromMessage(PolicyConflictException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyConflictException> {
        private Builder() {
            this.description(PolicyConflictException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId) {
            this();
            this.message(MessageFormat.format(PolicyConflictException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyConflictException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyConflictException(dittoHeaders, message, description, cause, href);
        }
    }
}

