/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyEntryModificationInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:entry.modificationinvalid";
    private static final String MESSAGE_TEMPLATE = "The PolicyEntry with Label ''{0}'' on the Policy with ID ''{1}'' could not be modified as the resulting Policy would be invalid.";
    private static final String DEFAULT_DESCRIPTION = "There must always be at least one PolicyEntry with 'WRITE' permissions on resource 'policy:/'.";
    private static final long serialVersionUID = -3234448123780175035L;

    private PolicyEntryModificationInvalidException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label) {
        return new Builder(policyId, label);
    }

    public static PolicyEntryModificationInvalidException fromMessage(String message, DittoHeaders dittoHeaders) {
        return PolicyEntryModificationInvalidException.fromMessage(message, null, dittoHeaders);
    }

    public static PolicyEntryModificationInvalidException fromMessage(String message, String description, DittoHeaders dittoHeaders) {
        DittoRuntimeExceptionBuilder builder = new Builder().dittoHeaders(dittoHeaders).message(message);
        if (description != null) {
            return (PolicyEntryModificationInvalidException)builder.description(description).build();
        }
        return (PolicyEntryModificationInvalidException)builder.build();
    }

    public static PolicyEntryModificationInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyEntryModificationInvalidException.fromMessage(PolicyEntryModificationInvalidException.readMessage((JsonObject)jsonObject), PolicyEntryModificationInvalidException.readDescription((JsonObject)jsonObject).orElse(null), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyEntryModificationInvalidException> {
        private Builder() {
            this.description(PolicyEntryModificationInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label) {
            this.description(PolicyEntryModificationInvalidException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(PolicyEntryModificationInvalidException.MESSAGE_TEMPLATE, label, policyId));
        }

        protected PolicyEntryModificationInvalidException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyEntryModificationInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

