/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyEntryNotModifiableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:entry.notmodifiable";
    private static final String MESSAGE_TEMPLATE = "The PolicyEntry with Label ''{0}'' on the Policy with ID ''{1}'' could not be modified as the requester had insufficient permissions.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of the Policy and the Label of your requested PolicyEntry was correct and you have sufficient permissions.";
    private static final long serialVersionUID = -1730675737558918923L;

    private PolicyEntryNotModifiableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label) {
        return new Builder(policyId, label);
    }

    public static PolicyEntryNotModifiableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyEntryNotModifiableException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static PolicyEntryNotModifiableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyEntryNotModifiableException.fromMessage(PolicyEntryNotModifiableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyEntryNotModifiableException> {
        private Builder() {
            this.description(PolicyEntryNotModifiableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label) {
            this.description(PolicyEntryNotModifiableException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(PolicyEntryNotModifiableException.MESSAGE_TEMPLATE, label, policyId));
        }

        protected PolicyEntryNotModifiableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyEntryNotModifiableException(dittoHeaders, message, description, cause, href);
        }
    }
}

