/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.policies.PolicyEntryInvalidException;
import org.eclipse.ditto.model.policies.PolicyIdInvalidException;
import org.eclipse.ditto.model.policies.SubjectIdInvalidException;
import org.eclipse.ditto.signals.base.AbstractErrorRegistry;
import org.eclipse.ditto.signals.base.ErrorRegistry;
import org.eclipse.ditto.signals.base.JsonParsable;
import org.eclipse.ditto.signals.commands.base.CommonErrorRegistry;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyConflictException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyEntryModificationInvalidException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyEntryNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyEntryNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyIdNotExplicitlySettableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyModificationInvalidException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyTooManyModifyingRequestsException;
import org.eclipse.ditto.signals.commands.policies.exceptions.PolicyUnavailableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourceNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourceNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourcesNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.ResourcesNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectNotAccessibleException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectNotModifiableException;
import org.eclipse.ditto.signals.commands.policies.exceptions.SubjectsNotModifiableException;

@Immutable
public final class PolicyErrorRegistry
extends AbstractErrorRegistry<DittoRuntimeException> {
    private PolicyErrorRegistry(Map<String, JsonParsable<DittoRuntimeException>> parseStrategies) {
        super(parseStrategies, (ErrorRegistry)CommonErrorRegistry.newInstance());
    }

    public static PolicyErrorRegistry newInstance() {
        HashMap<String, JsonParsable<DittoRuntimeException>> parseStrategies = new HashMap<String, JsonParsable<DittoRuntimeException>>();
        parseStrategies.put("policies:policy.conflict", PolicyConflictException::fromJson);
        parseStrategies.put("policies:id.invalid", PolicyIdInvalidException::fromJson);
        parseStrategies.put("policies:entry.invalid", PolicyEntryInvalidException::fromJson);
        parseStrategies.put("policies:subjectid.invalid", SubjectIdInvalidException::fromJson);
        parseStrategies.put("policies:policy.notfound", PolicyNotAccessibleException::fromJson);
        parseStrategies.put("policies:policy.notmodifiable", PolicyNotModifiableException::fromJson);
        parseStrategies.put("policies:id.notsettable", PolicyIdNotExplicitlySettableException::fromJson);
        parseStrategies.put("policies:policy.unavailable", PolicyUnavailableException::fromJson);
        parseStrategies.put("policies:policy.toomanymodifyingrequests", PolicyTooManyModifyingRequestsException::fromJson);
        parseStrategies.put("policies:entry.notfound", PolicyEntryNotAccessibleException::fromJson);
        parseStrategies.put("policies:entry.notmodifiable", PolicyEntryNotModifiableException::fromJson);
        parseStrategies.put("policies:entry.modificationinvalid", PolicyEntryModificationInvalidException::fromJson);
        parseStrategies.put("policies:policy.modificationinvalid", PolicyModificationInvalidException::fromJson);
        parseStrategies.put("policies:resources.notmodifiable", ResourcesNotModifiableException::fromJson);
        parseStrategies.put("policies:resource.notfound", ResourceNotAccessibleException::fromJson);
        parseStrategies.put("policies:resources.notfound", ResourcesNotAccessibleException::fromJson);
        parseStrategies.put("policies:resource.notmodifiable", ResourceNotModifiableException::fromJson);
        parseStrategies.put("policies:subjects.notmodifiable", SubjectsNotModifiableException::fromJson);
        parseStrategies.put("policies:subject.notfound", SubjectNotAccessibleException::fromJson);
        parseStrategies.put("policies:subject.notmodifiable", SubjectNotModifiableException::fromJson);
        parseStrategies.put("policies:subjects.notmodifiable", SubjectsNotModifiableException::fromJson);
        return new PolicyErrorRegistry(parseStrategies);
    }
}

