/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyIdNotExplicitlySettableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:id.notsettable";
    private static final String MESSAGE_TEMPLATE_PUT = "The Policy ID in the request body is not equal to the Policy ID in the request URL.";
    private static final String DEFAULT_DESCRIPTION_PUT = "Either delete the Policy ID from the request body or use the same Policy ID as in the request URL.";
    private static final long serialVersionUID = 2497658333219185859L;

    private PolicyIdNotExplicitlySettableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static PolicyIdNotExplicitlySettableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyIdNotExplicitlySettableException)new Builder().message(message).dittoHeaders(dittoHeaders).build();
    }

    public static PolicyIdNotExplicitlySettableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyIdNotExplicitlySettableException.fromMessage(PolicyIdNotExplicitlySettableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyIdNotExplicitlySettableException> {
        private Builder() {
            this.message(PolicyIdNotExplicitlySettableException.MESSAGE_TEMPLATE_PUT);
            this.description(PolicyIdNotExplicitlySettableException.DEFAULT_DESCRIPTION_PUT);
        }

        protected PolicyIdNotExplicitlySettableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyIdNotExplicitlySettableException(dittoHeaders, message, description, cause, href);
        }
    }
}

