/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyModificationInvalidException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.modificationinvalid";
    private static final String MESSAGE_TEMPLATE = "The Policy with ID ''{0}'' could not be modified as the resulting Policy would be invalid.";
    private static final String DEFAULT_DESCRIPTION = "There must always be at least one PolicyEntry with 'WRITE' permissions on resource 'policy:/'.";
    private static final long serialVersionUID = -3418662685041958745L;

    private PolicyModificationInvalidException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId) {
        return new Builder(policyId);
    }

    public static PolicyModificationInvalidException fromMessage(String message, DittoHeaders dittoHeaders) {
        return PolicyModificationInvalidException.fromMessage(message, null, dittoHeaders);
    }

    public static PolicyModificationInvalidException fromMessage(String message, @Nullable String description, DittoHeaders dittoHeaders) {
        DittoRuntimeExceptionBuilder builder = new Builder().dittoHeaders(dittoHeaders).message(message);
        if (description != null) {
            return (PolicyModificationInvalidException)builder.description(description).build();
        }
        return (PolicyModificationInvalidException)builder.build();
    }

    public static PolicyModificationInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyModificationInvalidException.fromMessage(PolicyModificationInvalidException.readMessage((JsonObject)jsonObject), PolicyModificationInvalidException.readDescription((JsonObject)jsonObject).orElse(null), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyModificationInvalidException> {
        private Builder() {
            this.description(PolicyModificationInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId) {
            this();
            this.message(MessageFormat.format(PolicyModificationInvalidException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyModificationInvalidException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyModificationInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

