/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyNotAccessibleException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.notfound";
    private static final String MESSAGE_TEMPLATE = "The Policy with ID ''{0}'' could not be found or requester had insufficient permissions to access it.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of your requested Policy was correct and you have sufficient permissions.";
    private static final long serialVersionUID = 5223919721644302865L;

    private PolicyNotAccessibleException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.NOT_FOUND, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId) {
        return new Builder(policyId);
    }

    public static PolicyNotAccessibleException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyNotAccessibleException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static PolicyNotAccessibleException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyNotAccessibleException.fromMessage(PolicyNotAccessibleException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyNotAccessibleException> {
        private Builder() {
            this.description(PolicyNotAccessibleException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId) {
            this();
            this.message(MessageFormat.format(PolicyNotAccessibleException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyNotAccessibleException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyNotAccessibleException(dittoHeaders, message, description, cause, href);
        }
    }
}

