/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyNotModifiableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.notmodifiable";
    private static final String MESSAGE_TEMPLATE = "The Policy with ID ''{0}'' could not be modified as the requester had insufficient permissions.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of your requested Policy was correct and you have sufficient permissions.";
    private static final long serialVersionUID = 6405617723219643100L;

    private PolicyNotModifiableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId) {
        return new Builder(policyId);
    }

    public static PolicyNotModifiableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyNotModifiableException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static PolicyNotModifiableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyNotModifiableException.fromMessage(PolicyNotModifiableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyNotModifiableException> {
        private Builder() {
            this.description(PolicyNotModifiableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId) {
            this();
            this.message(MessageFormat.format(PolicyNotModifiableException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyNotModifiableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyNotModifiableException(dittoHeaders, message, description, cause, href);
        }
    }
}

