/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyTooManyModifyingRequestsException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.toomanymodifyingrequests";
    private static final String MESSAGE_TEMPLATE = "Too many modifying requests are already outstanding to the Policy with ID ''{0}''.";
    private static final String DEFAULT_DESCRIPTION = "Throttle your modifying requests to the Policy or re-structure your Policy in multiple Policies if you really need so many concurrent modifications.";
    private static final long serialVersionUID = -3295800477795006307L;

    private PolicyTooManyModifyingRequestsException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.TOO_MANY_REQUESTS, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId) {
        return new Builder(policyId);
    }

    public static PolicyTooManyModifyingRequestsException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyTooManyModifyingRequestsException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static PolicyTooManyModifyingRequestsException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyTooManyModifyingRequestsException.fromMessage(PolicyTooManyModifyingRequestsException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyTooManyModifyingRequestsException> {
        private Builder() {
            this.description(PolicyTooManyModifyingRequestsException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId) {
            this();
            this.message(MessageFormat.format(PolicyTooManyModifyingRequestsException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyTooManyModifyingRequestsException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyTooManyModifyingRequestsException(dittoHeaders, message, description, cause, href);
        }
    }
}

