/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class PolicyUnavailableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:policy.unavailable";
    private static final String MESSAGE_TEMPLATE = "The Policy with ID ''{0}'' is not available, please try again later.";
    private static final String DEFAULT_DESCRIPTION = "The requested Policy is temporarily not available.";
    private static final long serialVersionUID = 1987286804137290070L;

    private PolicyUnavailableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.SERVICE_UNAVAILABLE, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId) {
        return new Builder(policyId);
    }

    public static PolicyUnavailableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (PolicyUnavailableException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static PolicyUnavailableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return PolicyUnavailableException.fromMessage(PolicyUnavailableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<PolicyUnavailableException> {
        private Builder() {
            this.description(PolicyUnavailableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId) {
            this();
            this.message(MessageFormat.format(PolicyUnavailableException.MESSAGE_TEMPLATE, policyId));
        }

        protected PolicyUnavailableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new PolicyUnavailableException(dittoHeaders, message, description, cause, href);
        }
    }
}

