/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class ResourceNotAccessibleException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:resource.notfound";
    private static final String MESSAGE_TEMPLATE = "The Resource ''{0}'' of the PolicyEntry with Label ''{1}'' on the Policy with ID ''{2}'' could not be found or requester had insufficient permissions to access it.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of the Policy, the Label of the PolicyEntry and the path of your requested Resource was correct and you have sufficient permissions.";
    private static final long serialVersionUID = 2620243998960976955L;

    private ResourceNotAccessibleException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.NOT_FOUND, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label, String path) {
        return new Builder(policyId, label, path);
    }

    public static ResourceNotAccessibleException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (ResourceNotAccessibleException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static ResourceNotAccessibleException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return ResourceNotAccessibleException.fromMessage(ResourceNotAccessibleException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ResourceNotAccessibleException> {
        private Builder() {
            this.description(ResourceNotAccessibleException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label, String path) {
            this.description(ResourceNotAccessibleException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(ResourceNotAccessibleException.MESSAGE_TEMPLATE, path, label, policyId));
        }

        protected ResourceNotAccessibleException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new ResourceNotAccessibleException(dittoHeaders, message, description, cause, href);
        }
    }
}

