/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class ResourceNotModifiableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:resource.notmodifiable";
    private static final String MESSAGE_TEMPLATE = "The Resource ''{0}'' of the PolicyEntry with Label ''{1}'' on the Policy with ID ''{2}'' could not be modified as the requester had insufficient permissions.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of the Policy, the Label of the PolicyEntry and the path of your requested Resource was correct and you have sufficient permissions.";
    private static final long serialVersionUID = -3333742392554340824L;

    private ResourceNotModifiableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label, CharSequence path) {
        return new Builder(policyId, label, path);
    }

    public static ResourceNotModifiableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (ResourceNotModifiableException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static ResourceNotModifiableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return ResourceNotModifiableException.fromMessage(ResourceNotModifiableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ResourceNotModifiableException> {
        private Builder() {
            this.description(ResourceNotModifiableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label, CharSequence path) {
            this.description(ResourceNotModifiableException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(ResourceNotModifiableException.MESSAGE_TEMPLATE, path, label, policyId));
        }

        protected ResourceNotModifiableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new ResourceNotModifiableException(dittoHeaders, message, description, cause, href);
        }
    }
}

