/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public class ResourcesNotAccessibleException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:resources.notfound";
    private static final String MESSAGE_TEMPLATE = "The Resources of the PolicyEntry with Label ''{0}'' on the Policy with ID ''{1}'' could not be found or requester had insufficient permissions to access it.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of the Policy and the Label of the PolicyEntry was correct and you have sufficient permissions.";
    private static final long serialVersionUID = -4536941108007531198L;

    private ResourcesNotAccessibleException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.NOT_FOUND, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label) {
        return new Builder(policyId, label);
    }

    public static ResourcesNotAccessibleException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (ResourcesNotAccessibleException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static ResourcesNotAccessibleException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return ResourcesNotAccessibleException.fromMessage(ResourcesNotAccessibleException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ResourcesNotAccessibleException> {
        private Builder() {
            this.description(ResourcesNotAccessibleException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label) {
            this.description(ResourcesNotAccessibleException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(ResourcesNotAccessibleException.MESSAGE_TEMPLATE, label, policyId));
        }

        protected ResourcesNotAccessibleException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new ResourcesNotAccessibleException(dittoHeaders, message, description, cause, href);
        }
    }
}

