/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class ResourcesNotModifiableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:resources.notmodifiable";
    private static final String MESSAGE_TEMPLATE = "The Resources of the PolicyEntry with Label ''{0}'' on the Policy with ID ''{1}'' could not be modified as the requester had insufficient permissions.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of the Policy and the PolicyEntry's Label of your requested Resources was correct and you have sufficient permissions.";
    private static final long serialVersionUID = 798042490341996073L;

    private ResourcesNotModifiableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label) {
        return new Builder(policyId, label);
    }

    public static ResourcesNotModifiableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (ResourcesNotModifiableException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static ResourcesNotModifiableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return ResourcesNotModifiableException.fromMessage(ResourcesNotModifiableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ResourcesNotModifiableException> {
        private Builder() {
            this.description(ResourcesNotModifiableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label) {
            this.description(ResourcesNotModifiableException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(ResourcesNotModifiableException.MESSAGE_TEMPLATE, label, policyId));
        }

        protected ResourcesNotModifiableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new ResourcesNotModifiableException(dittoHeaders, message, description, cause, href);
        }
    }
}

