/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.exceptions;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyException;

@Immutable
public final class SubjectsNotModifiableException
extends DittoRuntimeException
implements PolicyException {
    public static final String ERROR_CODE = "policies:subjects.notmodifiable";
    private static final String MESSAGE_TEMPLATE = "The Subjects of the PolicyEntry with Label ''{0}'' on the Policy with ID ''{1}'' could not be modified as the requester had insufficient permissions.";
    private static final String DEFAULT_DESCRIPTION = "Check if the ID of the Policy and the PolicyEntry's Label of your requested Subjects was correct and you have sufficient permissions.";
    private static final long serialVersionUID = -5186610086408398973L;

    private SubjectsNotModifiableException(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
        super(ERROR_CODE, HttpStatusCode.FORBIDDEN, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String policyId, CharSequence label) {
        return new Builder(policyId, label);
    }

    public static SubjectsNotModifiableException fromMessage(String message, DittoHeaders dittoHeaders) {
        return (SubjectsNotModifiableException)new Builder().dittoHeaders(dittoHeaders).message(message).build();
    }

    public static SubjectsNotModifiableException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return SubjectsNotModifiableException.fromMessage(SubjectsNotModifiableException.readMessage((JsonObject)jsonObject), dittoHeaders);
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<SubjectsNotModifiableException> {
        private Builder() {
            this.description(SubjectsNotModifiableException.DEFAULT_DESCRIPTION);
        }

        private Builder(String policyId, CharSequence label) {
            this.description(SubjectsNotModifiableException.DEFAULT_DESCRIPTION);
            this.message(MessageFormat.format(SubjectsNotModifiableException.MESSAGE_TEMPLATE, label, policyId));
        }

        protected SubjectsNotModifiableException doBuild(DittoHeaders dittoHeaders, String message, String description, Throwable cause, URI href) {
            return new SubjectsNotModifiableException(dittoHeaders, message, description, cause, href);
        }
    }
}

