/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyIdInvalidException;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class CreatePolicy
extends AbstractCommand<CreatePolicy>
implements PolicyModifyCommand<CreatePolicy> {
    public static final String NAME = "createPolicy";
    public static final String TYPE = "policies.commands:createPolicy";
    static final JsonFieldDefinition<JsonObject> JSON_POLICY = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policy", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final Policy policy;

    private CreatePolicy(Policy policy, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        this.policy = policy;
    }

    public static CreatePolicy of(Policy policy, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policy, "The Policy must not be null!");
        if (!policy.getId().isPresent()) {
            throw (PolicyIdInvalidException)PolicyIdInvalidException.newBuilder((CharSequence)"").message("Policy ID must be present in 'CreatePolicy' payload").dittoHeaders(dittoHeaders).build();
        }
        return new CreatePolicy(policy, dittoHeaders);
    }

    public static CreatePolicy fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return CreatePolicy.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static CreatePolicy fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (CreatePolicy)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            Policy policy = PoliciesModelFactory.newPolicy((JsonObject)((JsonObject)jsonObject.getValueOrThrow(JSON_POLICY)));
            return CreatePolicy.of(policy, dittoHeaders);
        });
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public String getId() {
        return (String)this.policy.getId().orElseThrow(() -> new NullPointerException("The Policy has no ID!"));
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.of(this.policy.toJson(schemaVersion, FieldType.regularOrSpecial()));
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(JSON_POLICY, (Object)this.policy.toJson(schemaVersion, thePredicate), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public CreatePolicy setDittoHeaders(DittoHeaders dittoHeaders) {
        return CreatePolicy.of(this.policy, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CreatePolicy;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        CreatePolicy that = (CreatePolicy)obj;
        return that.canEqual(this) && Objects.equals(this.policy, that.policy) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policy);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policy=" + this.policy + "]";
    }
}

