/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class DeletePolicy
extends AbstractCommand<DeletePolicy>
implements PolicyModifyCommand<DeletePolicy> {
    public static final String NAME = "deletePolicy";
    public static final String TYPE = "policies.commands:deletePolicy";
    private final String policyId;

    private DeletePolicy(String policyId, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
    }

    public static DeletePolicy of(String policyId, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The identifier of the Policy must not be null!");
        return new DeletePolicy(policyId, dittoHeaders);
    }

    public static DeletePolicy fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return DeletePolicy.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static DeletePolicy fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DeletePolicy)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            return DeletePolicy.of(policyId, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.DELETE;
    }

    @Override
    public DeletePolicy setDittoHeaders(DittoHeaders dittoHeaders) {
        return DeletePolicy.of(this.policyId, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeletePolicy;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        DeletePolicy that = (DeletePolicy)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + "]";
    }
}

