/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class DeletePolicyEntry
extends AbstractCommand<DeletePolicyEntry>
implements PolicyModifyCommand<DeletePolicyEntry> {
    public static final String NAME = "deletePolicyEntry";
    public static final String TYPE = "policies.commands:deletePolicyEntry";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;

    private DeletePolicyEntry(String policyId, Label label, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = label;
    }

    public static DeletePolicyEntry of(String policyId, Label label, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(label, "The Label must not be null!");
        return new DeletePolicyEntry(policyId, label, dittoHeaders);
    }

    public static DeletePolicyEntry fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return DeletePolicyEntry.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static DeletePolicyEntry fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DeletePolicyEntry)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            String stringLabel = (String)jsonObject.getValueOrThrow(JSON_LABEL);
            Label label = PoliciesModelFactory.newLabel((CharSequence)stringLabel);
            return DeletePolicyEntry.of(policyId, label, dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label;
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.DELETE;
    }

    @Override
    public DeletePolicyEntry setDittoHeaders(DittoHeaders dittoHeaders) {
        return DeletePolicyEntry.of(this.policyId, this.label, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeletePolicyEntry;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        DeletePolicyEntry that = (DeletePolicyEntry)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + "]";
    }
}

