/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class DeleteResource
extends AbstractCommand<DeleteResource>
implements PolicyModifyCommand<DeleteResource> {
    public static final String NAME = "deleteResource";
    public static final String TYPE = "policies.commands:deleteResource";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_RESOURCE_KEY = JsonFactory.newStringFieldDefinition((CharSequence)"resourceKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final ResourceKey resourceKey;

    private DeleteResource(String policyId, Label label, ResourceKey resourceKey, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = label;
        this.resourceKey = resourceKey;
    }

    public static DeleteResource of(String policyId, Label label, ResourceKey resourceKey, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(label, "The Label must not be null!");
        Objects.requireNonNull(resourceKey, "The ResourceKey must not be null!");
        return new DeleteResource(policyId, label, resourceKey, dittoHeaders);
    }

    public static DeleteResource fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return DeleteResource.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static DeleteResource fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DeleteResource)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String resourceKey = (String)jsonObject.getValueOrThrow(JSON_RESOURCE_KEY);
            return DeleteResource.of(policyId, label, ResourceKey.newInstance((CharSequence)resourceKey), dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        String p = "/entries/" + this.label + "/resources/" + this.resourceKey.toString();
        return JsonPointer.of((CharSequence)p);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCE_KEY, (Object)this.resourceKey.toString(), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.DELETE;
    }

    @Override
    public DeleteResource setDittoHeaders(DittoHeaders dittoHeaders) {
        return DeleteResource.of(this.policyId, this.label, this.resourceKey, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteResource;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteResource that = (DeleteResource)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resourceKey, that.resourceKey) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resourceKey);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resourceKey=" + this.resourceKey + "]";
    }
}

