/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class DeleteResourceResponse
extends AbstractCommandResponse<DeleteResourceResponse>
implements PolicyModifyCommandResponse<DeleteResourceResponse> {
    public static final String TYPE = "policies.responses:deleteResource";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_RESOURCE_KEY = JsonFactory.newStringFieldDefinition((CharSequence)"resourceKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final ResourceKey resourceKey;

    private DeleteResourceResponse(String policyId, Label label, ResourceKey resourceKey, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.resourceKey = (ResourceKey)ConditionChecker.checkNotNull((Object)resourceKey, (String)"ResourceKey");
    }

    public static DeleteResourceResponse of(String policyId, Label label, ResourceKey resourceKey, DittoHeaders dittoHeaders) {
        return new DeleteResourceResponse(policyId, label, resourceKey, HttpStatusCode.NO_CONTENT, dittoHeaders);
    }

    public static DeleteResourceResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return DeleteResourceResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static DeleteResourceResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DeleteResourceResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String path = (String)jsonObject.getValueOrThrow(JSON_RESOURCE_KEY);
            return DeleteResourceResponse.of(policyId, label, ResourceKey.newInstance((CharSequence)path), dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public JsonPointer getResourcePath() {
        String p = "/entries/" + this.label + "/resources/" + this.resourceKey.toString();
        return JsonPointer.of((CharSequence)p);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCE_KEY, (Object)this.resourceKey.toString(), predicate);
    }

    @Override
    public DeleteResourceResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return DeleteResourceResponse.of(this.policyId, this.label, this.resourceKey, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteResourceResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteResourceResponse that = (DeleteResourceResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resourceKey, that.resourceKey) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resourceKey);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resourceKey=" + this.resourceKey + "]";
    }
}

