/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class DeleteSubject
extends AbstractCommand<DeleteSubject>
implements PolicyModifyCommand<DeleteSubject> {
    public static final String NAME = "deleteSubject";
    public static final String TYPE = "policies.commands:deleteSubject";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_SUBJECT_ID = JsonFactory.newStringFieldDefinition((CharSequence)"subjectId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final SubjectId subjectId;

    private DeleteSubject(String policyId, Label label, SubjectId subjectId, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = label;
        this.subjectId = subjectId;
    }

    public static DeleteSubject of(String policyId, Label label, SubjectId subjectId, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(label, "The Label must not be null!");
        Objects.requireNonNull(subjectId, "The Subject identifier must not be null!");
        return new DeleteSubject(policyId, label, subjectId, dittoHeaders);
    }

    public static DeleteSubject fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return DeleteSubject.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static DeleteSubject fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DeleteSubject)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String stringSubjectId = (String)jsonObject.getValueOrThrow(JSON_SUBJECT_ID);
            SubjectId subjectId = PoliciesModelFactory.newSubjectId((CharSequence)stringSubjectId);
            return DeleteSubject.of(policyId, label, subjectId, dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public SubjectId getSubjectId() {
        return this.subjectId;
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/subjects/" + this.subjectId;
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_SUBJECT_ID, (Object)this.subjectId.toString(), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.DELETE;
    }

    @Override
    public DeleteSubject setDittoHeaders(DittoHeaders dittoHeaders) {
        return DeleteSubject.of(this.policyId, this.label, this.subjectId, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteSubject;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteSubject that = (DeleteSubject)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.subjectId, that.subjectId) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.subjectId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", subjectId=" + this.subjectId + "]";
    }
}

