/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.SubjectId;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class DeleteSubjectResponse
extends AbstractCommandResponse<DeleteSubjectResponse>
implements PolicyModifyCommandResponse<DeleteSubjectResponse> {
    public static final String TYPE = "policies.responses:deleteSubject";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_SUBJECT_ID = JsonFactory.newStringFieldDefinition((CharSequence)"subjectId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final SubjectId subjectId;

    private DeleteSubjectResponse(String policyId, Label label, SubjectId subjectId, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.subjectId = (SubjectId)ConditionChecker.checkNotNull((Object)subjectId, (String)"SubjectId");
    }

    public static DeleteSubjectResponse of(String policyId, Label label, SubjectId subjectId, DittoHeaders dittoHeaders) {
        return new DeleteSubjectResponse(policyId, label, subjectId, HttpStatusCode.NO_CONTENT, dittoHeaders);
    }

    public static DeleteSubjectResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return DeleteSubjectResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static DeleteSubjectResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (DeleteSubjectResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String stringSubjectId = (String)jsonObject.getValueOrThrow(JSON_SUBJECT_ID);
            SubjectId subjectId = PoliciesModelFactory.newSubjectId((CharSequence)stringSubjectId);
            return DeleteSubjectResponse.of(policyId, label, subjectId, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/subjects/" + this.subjectId;
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_SUBJECT_ID, (Object)this.subjectId.toString(), predicate);
    }

    @Override
    public DeleteSubjectResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return DeleteSubjectResponse.of(this.policyId, this.label, this.subjectId, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteSubjectResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteSubjectResponse that = (DeleteSubjectResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.subjectId, that.subjectId) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.subjectId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", subjectId=" + this.subjectId + "]";
    }
}

