/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class ModifyPolicy
extends AbstractCommand<ModifyPolicy>
implements PolicyModifyCommand<ModifyPolicy> {
    public static final String NAME = "modifyPolicy";
    public static final String TYPE = "policies.commands:modifyPolicy";
    static final JsonFieldDefinition<JsonObject> JSON_POLICY = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policy", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Policy policy;

    private ModifyPolicy(String policyId, Policy policy, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.policy = policy;
    }

    public static ModifyPolicy of(String policyId, Policy policy, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(policy, "The Policy must not be null!");
        return new ModifyPolicy(policyId, policy, dittoHeaders);
    }

    public static ModifyPolicy fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyPolicy.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyPolicy fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyPolicy)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            JsonObject policyJsonObject = (JsonObject)jsonObject.getValueOrThrow(JSON_POLICY);
            Policy policy = PoliciesModelFactory.newPolicy((JsonObject)policyJsonObject);
            Optional optionalPolicyId = jsonObject.getValue(PolicyCommand.JsonFields.JSON_POLICY_ID);
            String policyId = optionalPolicyId.orElseGet(() -> (String)policy.getId().orElseThrow(() -> new JsonMissingFieldException(PolicyCommand.JsonFields.JSON_POLICY_ID)));
            return ModifyPolicy.of(policyId, policy, dittoHeaders);
        });
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.of(this.policy.toJson(schemaVersion, FieldType.regularOrSpecial()));
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_POLICY, (Object)this.policy.toJson(schemaVersion, thePredicate), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public ModifyPolicy setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyPolicy.of(this.policyId, this.policy, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyPolicy;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyPolicy that = (ModifyPolicy)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policy, that.policy) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policy);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policy=" + this.policy + "]";
    }
}

