/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class ModifyPolicyEntries
extends AbstractCommand<ModifyPolicyEntries>
implements PolicyModifyCommand<ModifyPolicyEntries> {
    public static final String NAME = "modifyPolicyEntries";
    public static final String TYPE = "policies.commands:modifyPolicyEntries";
    static final JsonFieldDefinition<JsonObject> JSON_POLICY_ENTRIES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policyEntries", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Iterable<PolicyEntry> policyEntries;

    private ModifyPolicyEntries(String policyId, Iterable<PolicyEntry> policyEntries, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.policyEntries = policyEntries;
    }

    public static ModifyPolicyEntries of(String policyId, Iterable<PolicyEntry> policyEntries, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(policyEntries, "The PolicyEntries must not be null!");
        return new ModifyPolicyEntries(policyId, policyEntries, dittoHeaders);
    }

    public static ModifyPolicyEntries fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyPolicyEntries.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyPolicyEntries fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyPolicyEntries)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            JsonObject policyEntriesJsonObject = (JsonObject)jsonObject.getValueOrThrow(JSON_POLICY_ENTRIES);
            Iterable policyEntries = PoliciesModelFactory.newPolicyEntries((JsonObject)policyEntriesJsonObject);
            return ModifyPolicyEntries.of(policyId, policyEntries, dittoHeaders);
        });
    }

    public Iterable<PolicyEntry> getPolicyEntries() {
        return this.policyEntries;
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        JsonObject jsonObject = (JsonObject)StreamSupport.stream(this.policyEntries.spliterator(), false).map(entry -> JsonFactory.newObjectBuilder().set(entry.getLabel().getJsonFieldDefinition(), (Object)entry.toJson(schemaVersion, FieldType.regularOrSpecial())).build()).collect(JsonCollectors.objectsToObject());
        return Optional.ofNullable(jsonObject);
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.of((CharSequence)"/entries");
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_POLICY_ENTRIES, StreamSupport.stream(this.policyEntries.spliterator(), false).map(entry -> JsonFactory.newObjectBuilder().set(entry.getLabel().getJsonFieldDefinition(), (Object)entry.toJson(schemaVersion, thePredicate), predicate).build()).collect(JsonCollectors.objectsToObject()), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public ModifyPolicyEntries setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyPolicyEntries.of(this.policyId, this.policyEntries, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyPolicyEntries;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyPolicyEntries that = (ModifyPolicyEntries)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policyEntries, that.policyEntries) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policyEntries);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policyEntries=" + this.policyEntries + "]";
    }
}

