/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class ModifyPolicyEntriesResponse
extends AbstractCommandResponse<ModifyPolicyEntriesResponse>
implements PolicyModifyCommandResponse<ModifyPolicyEntriesResponse> {
    public static final String TYPE = "policies.responses:modifyPolicyEntries";
    private final String policyId;

    private ModifyPolicyEntriesResponse(String policyId, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
    }

    public static ModifyPolicyEntriesResponse of(String policyId, DittoHeaders dittoHeaders) {
        return new ModifyPolicyEntriesResponse(policyId, HttpStatusCode.NO_CONTENT, dittoHeaders);
    }

    public static ModifyPolicyEntriesResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyPolicyEntriesResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyPolicyEntriesResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyPolicyEntriesResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            return ModifyPolicyEntriesResponse.of(policyId, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.of((CharSequence)"/entries");
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
    }

    @Override
    public ModifyPolicyEntriesResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyPolicyEntriesResponse.of(this.policyId, dittoHeaders);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyPolicyEntriesResponse that = (ModifyPolicyEntriesResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyPolicyEntriesResponse;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + "]";
    }
}

