/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class ModifyPolicyEntry
extends AbstractCommand<ModifyPolicyEntry>
implements PolicyModifyCommand<ModifyPolicyEntry> {
    public static final String NAME = "modifyPolicyEntry";
    public static final String TYPE = "policies.commands:modifyPolicyEntry";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_POLICY_ENTRY = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policyEntry", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final PolicyEntry policyEntry;

    private ModifyPolicyEntry(String policyId, PolicyEntry policyEntry, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.policyEntry = policyEntry;
    }

    public static ModifyPolicyEntry of(String policyId, PolicyEntry policyEntry, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(policyEntry, "The PolicyEntry must not be null!");
        return new ModifyPolicyEntry(policyId, policyEntry, dittoHeaders);
    }

    public static ModifyPolicyEntry fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyPolicyEntry.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyPolicyEntry fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyPolicyEntry)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            String policyEntryLabel = (String)jsonObject.getValueOrThrow(JSON_LABEL);
            JsonObject policyEntryJsonObject = (JsonObject)jsonObject.getValueOrThrow(JSON_POLICY_ENTRY);
            PolicyEntry policyEntry = PoliciesModelFactory.newPolicyEntry((CharSequence)policyEntryLabel, (JsonObject)policyEntryJsonObject);
            return ModifyPolicyEntry.of(policyId, policyEntry, dittoHeaders);
        });
    }

    public PolicyEntry getPolicyEntry() {
        return this.policyEntry;
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.policyEntry.toJson(schemaVersion, FieldType.regularOrSpecial()));
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.policyEntry.getLabel();
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.policyEntry.getLabel().toString(), predicate);
        jsonObjectBuilder.set(JSON_POLICY_ENTRY, (Object)this.policyEntry.toJson(schemaVersion, thePredicate), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public ModifyPolicyEntry setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyPolicyEntry.of(this.policyId, this.policyEntry, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyPolicyEntry;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyPolicyEntry that = (ModifyPolicyEntry)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policyEntry, that.policyEntry) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policyEntry);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policyEntry=" + this.policyEntry + "]";
    }
}

