/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class ModifyPolicyEntryResponse
extends AbstractCommandResponse<ModifyPolicyEntryResponse>
implements PolicyModifyCommandResponse<ModifyPolicyEntryResponse> {
    public static final String TYPE = "policies.responses:modifyPolicyEntry";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonValue> JSON_POLICY_ENTRY = JsonFactory.newJsonValueFieldDefinition((CharSequence)"policyEntry", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    @Nullable
    private final PolicyEntry policyEntryCreated;

    private ModifyPolicyEntryResponse(String policyId, HttpStatusCode statusCode, @Nullable PolicyEntry policyEntryCreated, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.policyEntryCreated = policyEntryCreated;
    }

    public static ModifyPolicyEntryResponse created(String policyId, PolicyEntry policyEntryCreated, DittoHeaders dittoHeaders) {
        return new ModifyPolicyEntryResponse(policyId, HttpStatusCode.CREATED, policyEntryCreated, dittoHeaders);
    }

    public static ModifyPolicyEntryResponse modified(String policyId, DittoHeaders dittoHeaders) {
        return new ModifyPolicyEntryResponse(policyId, HttpStatusCode.NO_CONTENT, null, dittoHeaders);
    }

    public static ModifyPolicyEntryResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyPolicyEntryResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyPolicyEntryResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyPolicyEntryResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Optional readLabel = jsonObject.getValue(JSON_LABEL);
            PolicyEntry extractedPolicyEntryCreated = jsonObject.getValue(JSON_POLICY_ENTRY).filter(JsonValue::isObject).map(JsonValue::asObject).map(obj -> readLabel.map(s -> PoliciesModelFactory.newPolicyEntry((CharSequence)s, (JsonObject)obj)).orElse(null)).orElse(null);
            return new ModifyPolicyEntryResponse(policyId, statusCode, extractedPolicyEntryCreated, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<PolicyEntry> getPolicyEntryCreated() {
        return Optional.ofNullable(this.policyEntryCreated);
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.policyEntryCreated).map(obj -> (JsonObject)obj.toJson(schemaVersion, FieldType.notHidden()));
    }

    public JsonPointer getResourcePath() {
        if (this.policyEntryCreated == null) {
            return JsonPointer.empty();
        }
        String path = "/entries/" + this.policyEntryCreated.getLabel();
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        if (null != this.policyEntryCreated) {
            jsonObjectBuilder.set(JSON_LABEL, (Object)this.policyEntryCreated.getLabel().toString(), predicate);
            jsonObjectBuilder.set(JSON_POLICY_ENTRY, (Object)this.policyEntryCreated.toJson(schemaVersion, thePredicate), predicate);
        }
    }

    @Override
    public ModifyPolicyEntryResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return this.policyEntryCreated != null ? ModifyPolicyEntryResponse.created(this.policyId, this.policyEntryCreated, dittoHeaders) : ModifyPolicyEntryResponse.modified(this.policyId, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyPolicyEntryResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyPolicyEntryResponse that = (ModifyPolicyEntryResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policyEntryCreated, that.policyEntryCreated) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policyEntryCreated);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policyEntryCreated=" + this.policyEntryCreated + "]";
    }
}

