/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class ModifyPolicyResponse
extends AbstractCommandResponse<ModifyPolicyResponse>
implements PolicyModifyCommandResponse<ModifyPolicyResponse> {
    public static final String TYPE = "policies.responses:modifyPolicy";
    static final JsonFieldDefinition<JsonValue> JSON_POLICY = JsonFactory.newJsonValueFieldDefinition((CharSequence)"policy", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    @Nullable
    private final Policy policyCreated;

    private ModifyPolicyResponse(String policyId, HttpStatusCode statusCode, @Nullable Policy policyCreated, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.policyCreated = policyCreated;
    }

    public static ModifyPolicyResponse created(String policyId, Policy policy, DittoHeaders dittoHeaders) {
        return new ModifyPolicyResponse(policyId, HttpStatusCode.CREATED, policy, dittoHeaders);
    }

    public static ModifyPolicyResponse modified(String policyId, DittoHeaders dittoHeaders) {
        return new ModifyPolicyResponse(policyId, HttpStatusCode.NO_CONTENT, null, dittoHeaders);
    }

    public static ModifyPolicyResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyPolicyResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyPolicyResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyPolicyResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Policy extractedPolicyCreated = jsonObject.getValue(JSON_POLICY).map(JsonValue::asObject).map(PoliciesModelFactory::newPolicy).orElse(null);
            return new ModifyPolicyResponse(policyId, statusCode, extractedPolicyCreated, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<Policy> getPolicyCreated() {
        return Optional.ofNullable(this.policyCreated);
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.policyCreated).map(obj -> (JsonObject)obj.toJson(schemaVersion, FieldType.notHidden()));
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        if (null != this.policyCreated) {
            jsonObjectBuilder.set(JSON_POLICY, (Object)this.policyCreated.toJson(schemaVersion, thePredicate), predicate);
        }
    }

    @Override
    public ModifyPolicyResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return null != this.policyCreated ? ModifyPolicyResponse.created(this.policyId, this.policyCreated, dittoHeaders) : ModifyPolicyResponse.modified(this.policyId, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyPolicyResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyPolicyResponse that = (ModifyPolicyResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policyCreated, that.policyCreated) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policyCreated);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policyCreated=" + this.policyCreated + "]";
    }
}

