/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class ModifyResource
extends AbstractCommand<ModifyResource>
implements PolicyModifyCommand<ModifyResource> {
    public static final String NAME = "modifyResource";
    public static final String TYPE = "policies.commands:modifyResource";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_RESOURCE_KEY = JsonFactory.newStringFieldDefinition((CharSequence)"resourceKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_RESOURCE = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"resource", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final Resource resource;

    private ModifyResource(String policyId, Label label, Resource resource, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = label;
        this.resource = resource;
    }

    public static ModifyResource of(String policyId, Label label, Resource resource, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(label, "The Label must not be null!");
        Objects.requireNonNull(resource, "The Resource must not be null!");
        return new ModifyResource(policyId, label, resource, dittoHeaders);
    }

    public static ModifyResource fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyResource.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyResource fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyResource)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String resourceKey = (String)jsonObject.getValueOrThrow(JSON_RESOURCE_KEY);
            JsonObject resourceJsonObject = (JsonObject)jsonObject.getValueOrThrow(JSON_RESOURCE);
            Resource resource = PoliciesModelFactory.newResource((ResourceKey)ResourceKey.newInstance((CharSequence)resourceKey), (JsonValue)resourceJsonObject);
            return ModifyResource.of(policyId, label, resource, dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.resource.toJson(schemaVersion, FieldType.regularOrSpecial()));
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/resources/" + this.resource.getResourceKey();
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCE_KEY, (Object)this.resource.getFullQualifiedPath(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCE, (Object)this.resource.toJson(schemaVersion, thePredicate), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public ModifyResource setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyResource.of(this.policyId, this.label, this.resource, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyResource;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyResource that = (ModifyResource)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resource, that.resource) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resource);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resource=" + this.resource + "]";
    }
}

