/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class ModifyResourceResponse
extends AbstractCommandResponse<ModifyResourceResponse>
implements PolicyModifyCommandResponse<ModifyResourceResponse> {
    public static final String TYPE = "policies.responses:modifyResource";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_RESOURCE_KEY = JsonFactory.newStringFieldDefinition((CharSequence)"resourceKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonValue> JSON_RESOURCE = JsonFactory.newJsonValueFieldDefinition((CharSequence)"resource", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    @Nullable
    private final Resource resourceCreated;

    private ModifyResourceResponse(String policyId, Label label, @Nullable Resource resourceCreated, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.resourceCreated = resourceCreated;
    }

    public static ModifyResourceResponse created(String policyId, Label label, Resource resourceCreated, DittoHeaders dittoHeaders) {
        return new ModifyResourceResponse(policyId, label, resourceCreated, HttpStatusCode.CREATED, dittoHeaders);
    }

    public static ModifyResourceResponse modified(String policyId, Label label, DittoHeaders dittoHeaders) {
        return new ModifyResourceResponse(policyId, label, null, HttpStatusCode.NO_CONTENT, dittoHeaders);
    }

    public static ModifyResourceResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyResourceResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyResourceResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyResourceResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            String stringLabel = (String)jsonObject.getValueOrThrow(JSON_LABEL);
            Label label = PoliciesModelFactory.newLabel((CharSequence)stringLabel);
            Optional<ResourceKey> extractedResourceKey = jsonObject.getValue(JSON_RESOURCE_KEY).map(ResourceKey::newInstance);
            Resource extractedResourceCreated = jsonObject.getValue(JSON_RESOURCE).map(JsonValue::asObject).map(obj -> extractedResourceKey.map(resourceKey -> PoliciesModelFactory.newResource((ResourceKey)resourceKey, (JsonValue)obj)).orElse(null)).orElse(null);
            return new ModifyResourceResponse(policyId, label, extractedResourceCreated, statusCode, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public Optional<Resource> getResourceCreated() {
        return Optional.ofNullable(this.resourceCreated);
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.resourceCreated).map(obj -> (JsonObject)obj.toJson(schemaVersion, FieldType.notHidden()));
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/resources/" + this.resourceCreated.getResourceKey();
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        if (null != this.resourceCreated) {
            jsonObjectBuilder.set(JSON_RESOURCE_KEY, (Object)this.resourceCreated.getFullQualifiedPath(), predicate);
            jsonObjectBuilder.set(JSON_RESOURCE, (Object)this.resourceCreated.toJson(schemaVersion, thePredicate), predicate);
        }
    }

    @Override
    public ModifyResourceResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return null != this.resourceCreated ? ModifyResourceResponse.created(this.policyId, this.label, this.resourceCreated, dittoHeaders) : ModifyResourceResponse.modified(this.policyId, this.label, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyResourceResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyResourceResponse that = (ModifyResourceResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resourceCreated, that.resourceCreated) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resourceCreated);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resourceCreated=" + this.resourceCreated + "]";
    }
}

