/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class ModifyResources
extends AbstractCommand<ModifyResources>
implements PolicyModifyCommand<ModifyResources> {
    public static final String NAME = "modifyResources";
    public static final String TYPE = "policies.commands:modifyResources";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_RESOURCES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"resources", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final Resources resources;

    private ModifyResources(String policyId, Label label, Resources resources, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = label;
        this.resources = resources;
    }

    public static ModifyResources of(String policyId, Label label, Resources resources, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(label, "The Label must not be null!");
        Objects.requireNonNull(resources, "The Resources must not be null!");
        return new ModifyResources(policyId, label, resources, dittoHeaders);
    }

    public static ModifyResources fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyResources.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyResources fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyResources)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            JsonObject resourcesJsonObject = (JsonObject)jsonObject.getValueOrThrow(JSON_RESOURCES);
            Resources resources = PoliciesModelFactory.newResources((JsonObject)resourcesJsonObject);
            return ModifyResources.of(policyId, label, resources, dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.resources.toJson(schemaVersion, FieldType.regularOrSpecial()));
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/resources";
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCES, (Object)this.resources.toJson(schemaVersion, thePredicate), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public ModifyResources setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyResources.of(this.policyId, this.label, this.resources, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyResources;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ModifyResources that = (ModifyResources)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resources, that.resources) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resources=" + this.resources + "]";
    }
}

