/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class ModifyResourcesResponse
extends AbstractCommandResponse<ModifyResourcesResponse>
implements PolicyModifyCommandResponse<ModifyResourcesResponse> {
    public static final String TYPE = "policies.responses:modifyResources";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;

    private ModifyResourcesResponse(String policyId, Label label, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
    }

    public static ModifyResourcesResponse of(String policyId, Label label, DittoHeaders dittoHeaders) {
        return new ModifyResourcesResponse(policyId, label, HttpStatusCode.NO_CONTENT, dittoHeaders);
    }

    public static ModifyResourcesResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifyResourcesResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifyResourcesResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifyResourcesResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            return new ModifyResourcesResponse(policyId, label, statusCode, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/resources";
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
    }

    @Override
    public ModifyResourcesResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifyResourcesResponse.of(this.policyId, this.label, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifyResourcesResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModifyResourcesResponse that = (ModifyResourcesResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + "]";
    }
}

