/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommandResponse;

@Immutable
public final class ModifySubjectResponse
extends AbstractCommandResponse<ModifySubjectResponse>
implements PolicyModifyCommandResponse<ModifySubjectResponse> {
    public static final String TYPE = "policies.responses:modifySubject";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_SUBJECT_ID = JsonFactory.newStringFieldDefinition((CharSequence)"subjectId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonValue> JSON_SUBJECT = JsonFactory.newJsonValueFieldDefinition((CharSequence)"subject", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    @Nullable
    private final Subject subjectCreated;

    private ModifySubjectResponse(String policyId, Label label, @Nullable Subject subjectCreated, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.subjectCreated = subjectCreated;
    }

    public static ModifySubjectResponse created(String policyId, Label label, Subject subjectCreated, DittoHeaders dittoHeaders) {
        return new ModifySubjectResponse(policyId, label, subjectCreated, HttpStatusCode.CREATED, dittoHeaders);
    }

    public static ModifySubjectResponse modified(String policyId, Label label, DittoHeaders dittoHeaders) {
        return new ModifySubjectResponse(policyId, label, null, HttpStatusCode.NO_CONTENT, dittoHeaders);
    }

    public static ModifySubjectResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifySubjectResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifySubjectResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifySubjectResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            Optional extractedSubjectId = jsonObject.getValue(JSON_SUBJECT_ID);
            Subject extractedSubjectCreated = jsonObject.getValue(JSON_SUBJECT).map(JsonValue::asObject).map(obj -> extractedSubjectId.map(s -> PoliciesModelFactory.newSubject((CharSequence)s, (JsonObject)obj)).orElse(null)).orElse(null);
            return new ModifySubjectResponse(policyId, label, extractedSubjectCreated, statusCode, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public Optional<Subject> getSubjectCreated() {
        return Optional.ofNullable(this.subjectCreated);
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.ofNullable(this.subjectCreated).map(obj -> (JsonObject)obj.toJson(schemaVersion, FieldType.notHidden()));
    }

    public JsonPointer getResourcePath() {
        if (this.subjectCreated == null) {
            return JsonPointer.empty();
        }
        String path = "/entries/" + this.label + "/subjects/" + this.subjectCreated.getId();
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        if (null != this.subjectCreated) {
            jsonObjectBuilder.set(JSON_SUBJECT_ID, (Object)this.subjectCreated.getId().toString(), predicate);
            jsonObjectBuilder.set(JSON_SUBJECT, (Object)this.subjectCreated.toJson(schemaVersion, thePredicate), predicate);
        }
    }

    @Override
    public ModifySubjectResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return this.subjectCreated != null ? ModifySubjectResponse.created(this.policyId, this.label, this.subjectCreated, dittoHeaders) : ModifySubjectResponse.modified(this.policyId, this.label, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifySubjectResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifySubjectResponse that = (ModifySubjectResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.subjectCreated, that.subjectCreated) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.subjectCreated);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", subjectCreated=" + this.subjectCreated + "]";
    }
}

