/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.modify;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.model.policies.Subjects;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.Command;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.modify.PolicyModifyCommand;

@Immutable
public final class ModifySubjects
extends AbstractCommand<ModifySubjects>
implements PolicyModifyCommand<ModifySubjects> {
    public static final String NAME = "modifySubjects";
    public static final String TYPE = "policies.commands:modifySubjects";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_SUBJECTS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"subjects", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final Subjects subjects;

    private ModifySubjects(String policyId, Label label, Subjects subjects, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = label;
        this.subjects = subjects;
    }

    public static ModifySubjects of(String policyId, Label label, Subjects subjects, DittoHeaders dittoHeaders) {
        Objects.requireNonNull(policyId, "The Policy identifier must not be null!");
        Objects.requireNonNull(label, "The Label must not be null!");
        Objects.requireNonNull(subjects, "The Subjects must not be null!");
        return new ModifySubjects(policyId, label, subjects, dittoHeaders);
    }

    public static ModifySubjects fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return ModifySubjects.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static ModifySubjects fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ModifySubjects)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            Subjects subjects = PoliciesModelFactory.newSubjects((JsonObject)((JsonObject)jsonObject.getValueOrThrow(JSON_SUBJECTS)));
            return ModifySubjects.of(policyId, label, subjects, dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public Subjects getSubjects() {
        return this.subjects;
    }

    public String getId() {
        return this.policyId;
    }

    public Optional<JsonValue> getEntity(JsonSchemaVersion schemaVersion) {
        return Optional.of(this.subjects.toJson(schemaVersion, FieldType.regularOrSpecial()));
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/subjects";
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_SUBJECTS, (Object)this.subjects.toJson(schemaVersion, thePredicate), predicate);
    }

    public Command.Category getCategory() {
        return Command.Category.MODIFY;
    }

    @Override
    public ModifySubjects setDittoHeaders(DittoHeaders dittoHeaders) {
        return ModifySubjects.of(this.policyId, this.label, this.subjects, dittoHeaders);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ModifySubjects;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        ModifySubjects that = (ModifySubjects)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.subjects, that.subjects) && super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.subjects);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", subjects=" + this.subjects + "]";
    }
}

