/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommand;

@Immutable
public final class RetrievePolicy
extends AbstractCommand<RetrievePolicy>
implements PolicyQueryCommand<RetrievePolicy> {
    public static final String NAME = "retrievePolicy";
    public static final String TYPE = "policies.commands:retrievePolicy";
    private final String policyId;

    private RetrievePolicy(String policyId, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
    }

    public static RetrievePolicy of(String policyId, DittoHeaders dittoHeaders) {
        return new RetrievePolicy(policyId, dittoHeaders);
    }

    public static RetrievePolicy fromJson(String jsonString, DittoHeaders dittoHeaders) {
        JsonObject jsonObject = JsonFactory.newObject((String)jsonString);
        return RetrievePolicy.fromJson(jsonObject, dittoHeaders);
    }

    public static RetrievePolicy fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrievePolicy)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            return RetrievePolicy.of(policyId, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
    }

    @Override
    public RetrievePolicy setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrievePolicy.of(this.policyId, dittoHeaders);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RetrievePolicy that = (RetrievePolicy)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && super.equals((Object)that);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrievePolicy;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + "]";
    }
}

