/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrievePolicyEntriesResponse
extends AbstractCommandResponse<RetrievePolicyEntriesResponse>
implements PolicyQueryCommandResponse<RetrievePolicyEntriesResponse> {
    public static final String TYPE = "policies.responses:retrievePolicyEntries";
    static final JsonFieldDefinition<JsonObject> JSON_POLICY_ENTRIES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policyEntries", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final JsonObject policyEntries;

    private RetrievePolicyEntriesResponse(String policyId, HttpStatusCode statusCode, JsonObject policyEntries, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.policyEntries = (JsonObject)ConditionChecker.checkNotNull((Object)policyEntries, (String)"Policy entry");
    }

    public static RetrievePolicyEntriesResponse of(String policyId, Iterable<PolicyEntry> policyEntries, DittoHeaders dittoHeaders) {
        JsonObjectBuilder objectBuilder = JsonFactory.newObjectBuilder();
        ((Iterable)ConditionChecker.checkNotNull(policyEntries, (String)"Policy Entries")).forEach(entry -> objectBuilder.set((CharSequence)entry.getLabel().toString(), entry.toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(JsonSchemaVersion.LATEST))));
        return new RetrievePolicyEntriesResponse(policyId, HttpStatusCode.OK, objectBuilder.build(), dittoHeaders);
    }

    public static RetrievePolicyEntriesResponse of(String policyId, JsonObject policyEntries, DittoHeaders dittoHeaders) {
        return new RetrievePolicyEntriesResponse(policyId, HttpStatusCode.OK, policyEntries, dittoHeaders);
    }

    public static RetrievePolicyEntriesResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrievePolicyEntriesResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrievePolicyEntriesResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrievePolicyEntriesResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            JsonObject extractedPolicyEntries = (JsonObject)jsonObject.getValueOrThrow(JSON_POLICY_ENTRIES);
            return RetrievePolicyEntriesResponse.of(policyId, extractedPolicyEntries, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Iterable<PolicyEntry> getPolicyEntries() {
        return PoliciesModelFactory.newPolicyEntries((JsonObject)this.policyEntries);
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.policyEntries;
    }

    @Override
    public RetrievePolicyEntriesResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrievePolicyEntriesResponse.of(this.policyId, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrievePolicyEntriesResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrievePolicyEntriesResponse.of(this.policyId, this.policyEntries, dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.of((CharSequence)"/entries");
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_POLICY_ENTRIES, (Object)this.policyEntries, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrievePolicyEntriesResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrievePolicyEntriesResponse that = (RetrievePolicyEntriesResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policyEntries, that.policyEntries) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policyEntries);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policyEntries=" + this.policyEntries + "]";
    }
}

