/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.PolicyEntry;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrievePolicyEntryResponse
extends AbstractCommandResponse<RetrievePolicyEntryResponse>
implements PolicyQueryCommandResponse<RetrievePolicyEntryResponse> {
    public static final String TYPE = "policies.responses:retrievePolicyEntry";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_POLICY_ENTRY = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policyEntry", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final String policyEntryLabel;
    private final JsonObject policyEntry;

    private RetrievePolicyEntryResponse(String policyId, HttpStatusCode statusCode, String policyEntryLabel, JsonObject policyEntry, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.policyEntryLabel = (String)ConditionChecker.checkNotNull((Object)policyEntryLabel, (String)"Policy entry label");
        this.policyEntry = (JsonObject)ConditionChecker.checkNotNull((Object)policyEntry, (String)"Policy entry");
    }

    public static RetrievePolicyEntryResponse of(String policyId, PolicyEntry policyEntry, DittoHeaders dittoHeaders) {
        return new RetrievePolicyEntryResponse(policyId, HttpStatusCode.OK, policyEntry.getLabel().toString(), (JsonObject)((PolicyEntry)ConditionChecker.checkNotNull((Object)policyEntry, (String)"Policy Entry")).toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(policyEntry.getLatestSchemaVersion())), dittoHeaders);
    }

    public static RetrievePolicyEntryResponse of(String policyId, String policyEntryLabel, JsonObject policyEntry, DittoHeaders dittoHeaders) {
        return new RetrievePolicyEntryResponse(policyId, HttpStatusCode.OK, policyEntryLabel, policyEntry, dittoHeaders);
    }

    public static RetrievePolicyEntryResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrievePolicyEntryResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrievePolicyEntryResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrievePolicyEntryResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            String extractedLabel = (String)jsonObject.getValueOrThrow(JSON_LABEL);
            JsonObject extractedPolicyEntry = (JsonObject)jsonObject.getValueOrThrow(JSON_POLICY_ENTRY);
            return RetrievePolicyEntryResponse.of(policyId, extractedLabel, extractedPolicyEntry, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public PolicyEntry getPolicyEntry() {
        return PoliciesModelFactory.newPolicyEntry((CharSequence)this.policyEntryLabel, (JsonObject)this.policyEntry);
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.policyEntry;
    }

    @Override
    public RetrievePolicyEntryResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrievePolicyEntryResponse.of(this.policyId, this.policyEntryLabel, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrievePolicyEntryResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrievePolicyEntryResponse.of(this.policyId, this.policyEntryLabel, this.policyEntry, dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.policyEntryLabel;
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.policyEntryLabel, predicate);
        jsonObjectBuilder.set(JSON_POLICY_ENTRY, (Object)this.policyEntry, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrievePolicyEntryResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrievePolicyEntryResponse that = (RetrievePolicyEntryResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policyEntryLabel, that.policyEntryLabel) && Objects.equals(this.policyEntry, that.policyEntry) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policyEntryLabel, this.policyEntry);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policyEntryLabel=" + this.policyEntryLabel + ", policyEntry=" + this.policyEntry + "]";
    }
}

