/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Policy;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrievePolicyResponse
extends AbstractCommandResponse<RetrievePolicyResponse>
implements PolicyQueryCommandResponse<RetrievePolicyResponse> {
    public static final String TYPE = "policies.responses:retrievePolicy";
    static final JsonFieldDefinition<JsonObject> JSON_POLICY = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"policy", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final JsonObject policy;

    private RetrievePolicyResponse(String policyId, HttpStatusCode statusCode, JsonObject policy, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.policy = (JsonObject)ConditionChecker.checkNotNull((Object)policy, (String)"Policy");
    }

    public static RetrievePolicyResponse of(String policyId, Policy policy, DittoHeaders dittoHeaders) {
        return new RetrievePolicyResponse(policyId, HttpStatusCode.OK, (JsonObject)((Policy)ConditionChecker.checkNotNull((Object)policy, (String)"Policy")).toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(policy.getLatestSchemaVersion())), dittoHeaders);
    }

    public static RetrievePolicyResponse of(String policyId, JsonObject policy, DittoHeaders dittoHeaders) {
        return new RetrievePolicyResponse(policyId, HttpStatusCode.OK, policy, dittoHeaders);
    }

    public static RetrievePolicyResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrievePolicyResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrievePolicyResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrievePolicyResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            JsonObject extractedPolicy = (JsonObject)jsonObject.getValueOrThrow(JSON_POLICY);
            return RetrievePolicyResponse.of(policyId, extractedPolicy, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Policy getPolicy() {
        return PoliciesModelFactory.newPolicy((JsonObject)this.policy);
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.policy;
    }

    @Override
    public RetrievePolicyResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrievePolicyResponse.of(this.policyId, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrievePolicyResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrievePolicyResponse.of(this.policyId, this.policy, dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        return JsonPointer.empty();
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_POLICY, (Object)this.policy, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrievePolicyResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrievePolicyResponse that = (RetrievePolicyResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.policy, that.policy) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.policy);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", policy=" + this.policy + "]";
    }
}

