/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Resource;
import org.eclipse.ditto.model.policies.ResourceKey;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrieveResourceResponse
extends AbstractCommandResponse<RetrieveResourceResponse>
implements PolicyQueryCommandResponse<RetrieveResourceResponse> {
    public static final String TYPE = "policies.responses:retrieveResource";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_RESOURCE_KEY = JsonFactory.newStringFieldDefinition((CharSequence)"resourceKey", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_RESOURCE = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"resource", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final ResourceKey resourceKey;
    private final JsonObject resource;

    private RetrieveResourceResponse(String policyId, Label label, ResourceKey resourceKey, JsonObject resource, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.resourceKey = (ResourceKey)ConditionChecker.checkNotNull((Object)resourceKey, (String)"ResourceKey");
        this.resource = (JsonObject)ConditionChecker.checkNotNull((Object)resource, (String)"Resource");
    }

    public static RetrieveResourceResponse of(String policyId, Label label, Resource resource, DittoHeaders dittoHeaders) {
        return new RetrieveResourceResponse(policyId, label, resource.getResourceKey(), (JsonObject)((Resource)ConditionChecker.checkNotNull((Object)resource, (String)"Resource")).toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(resource.getLatestSchemaVersion())), HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveResourceResponse of(String policyId, Label label, ResourceKey resourceKey, JsonObject resource, DittoHeaders dittoHeaders) {
        return new RetrieveResourceResponse(policyId, label, resourceKey, resource, HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveResourceResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrieveResourceResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrieveResourceResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrieveResourceResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String extractedResourceKey = (String)jsonObject.getValueOrThrow(JSON_RESOURCE_KEY);
            JsonObject extractedResource = (JsonObject)jsonObject.getValueOrThrow(JSON_RESOURCE);
            return RetrieveResourceResponse.of(policyId, label, ResourceKey.newInstance((CharSequence)extractedResourceKey), extractedResource, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public Resource getResource() {
        return PoliciesModelFactory.newResource((ResourceKey)this.resourceKey, (JsonValue)this.resource);
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.resource;
    }

    @Override
    public RetrieveResourceResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrieveResourceResponse.of(this.policyId, this.label, this.resourceKey, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrieveResourceResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveResourceResponse.of(this.policyId, this.label, this.getResource(), dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        String p = "/entries/" + this.label + "/resources/" + this.resourceKey;
        return JsonPointer.of((CharSequence)p);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCE_KEY, (Object)this.resourceKey.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCE, (Object)this.resource, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrieveResourceResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveResourceResponse that = (RetrieveResourceResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resourceKey, that.resourceKey) && Objects.equals(this.resource, that.resource) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resourceKey, this.resource);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resourceKey=" + this.resourceKey + ", resource=" + this.resource + "]";
    }
}

