/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Resources;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrieveResourcesResponse
extends AbstractCommandResponse<RetrieveResourcesResponse>
implements PolicyQueryCommandResponse<RetrieveResourcesResponse> {
    public static final String TYPE = "policies.responses:retrieveResources";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_RESOURCES = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"resources", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final JsonObject resources;

    private RetrieveResourcesResponse(String policyId, Label label, JsonObject resources, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.resources = (JsonObject)ConditionChecker.checkNotNull((Object)resources, (String)"Resources");
    }

    public static RetrieveResourcesResponse of(String policyId, Label label, Resources resources, DittoHeaders dittoHeaders) {
        return new RetrieveResourcesResponse(policyId, label, (JsonObject)((Resources)ConditionChecker.checkNotNull((Object)resources, (String)"Resources")).toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(resources.getLatestSchemaVersion())), HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveResourcesResponse of(String policyId, Label label, JsonObject resources, DittoHeaders dittoHeaders) {
        return new RetrieveResourcesResponse(policyId, label, resources, HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveResourcesResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrieveResourcesResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrieveResourcesResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrieveResourcesResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            JsonObject extractedResources = (JsonObject)jsonObject.getValueOrThrow(JSON_RESOURCES);
            return RetrieveResourcesResponse.of(policyId, label, extractedResources, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public Resources getResources() {
        return PoliciesModelFactory.newResources((JsonObject)this.resources);
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.resources;
    }

    @Override
    public RetrieveResourcesResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrieveResourcesResponse.of(this.policyId, this.label, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrieveResourcesResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveResourcesResponse.of(this.policyId, this.label, this.resources, dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/resources";
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_RESOURCES, (Object)this.resources, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrieveResourcesResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveResourcesResponse that = (RetrieveResourcesResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.resources, that.resources) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", resources=" + this.resources + "]";
    }
}

