/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Subject;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrieveSubjectResponse
extends AbstractCommandResponse<RetrieveSubjectResponse>
implements PolicyQueryCommandResponse<RetrieveSubjectResponse> {
    public static final String TYPE = "policies.responses:retrieveSubject";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<String> JSON_SUBJECT_ID = JsonFactory.newStringFieldDefinition((CharSequence)"subjectId", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_SUBJECT = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"subject", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final String subjectId;
    private final JsonObject subject;

    private RetrieveSubjectResponse(String policyId, Label label, String subjectId, JsonObject subject, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.subjectId = (String)ConditionChecker.checkNotNull((Object)subjectId, (String)"Subject ID");
        this.subject = (JsonObject)ConditionChecker.checkNotNull((Object)subject, (String)"Subject");
    }

    public static RetrieveSubjectResponse of(String policyId, Label label, String subjectId, JsonObject subject, DittoHeaders dittoHeaders) {
        return new RetrieveSubjectResponse(policyId, label, subjectId, subject, HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveSubjectResponse of(String policyId, Label label, Subject subject, DittoHeaders dittoHeaders) {
        return new RetrieveSubjectResponse(policyId, label, subject.getId().toString(), (JsonObject)((Subject)ConditionChecker.checkNotNull((Object)subject, (String)"Subject")).toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(subject.getLatestSchemaVersion())), HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveSubjectResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrieveSubjectResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrieveSubjectResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrieveSubjectResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            String extractedSubjectId = (String)jsonObject.getValueOrThrow(JSON_SUBJECT_ID);
            JsonObject extractedSubject = (JsonObject)jsonObject.getValueOrThrow(JSON_SUBJECT);
            return RetrieveSubjectResponse.of(policyId, label, extractedSubjectId, extractedSubject, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public Subject getSubject() {
        return PoliciesModelFactory.newSubject((CharSequence)this.subjectId, (JsonObject)this.subject);
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.subject;
    }

    @Override
    public RetrieveSubjectResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrieveSubjectResponse.of(this.policyId, this.label, this.subjectId, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrieveSubjectResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveSubjectResponse.of(this.policyId, this.label, this.getSubject(), dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/subjects/" + this.subjectId;
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_SUBJECT_ID, (Object)this.subjectId, predicate);
        jsonObjectBuilder.set(JSON_SUBJECT, (Object)this.subject, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrieveSubjectResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveSubjectResponse that = (RetrieveSubjectResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.subjectId, that.subjectId) && Objects.equals(this.subject, that.subject) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.subjectId, this.subject);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", subjectId=" + this.subjectId + ", subject=" + this.subject + "]";
    }
}

