/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PolicyIdValidator;
import org.eclipse.ditto.signals.commands.base.AbstractCommand;
import org.eclipse.ditto.signals.commands.base.CommandJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommand;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommand;

@Immutable
public final class RetrieveSubjects
extends AbstractCommand<RetrieveSubjects>
implements PolicyQueryCommand<RetrieveSubjects> {
    public static final String NAME = "retrieveSubjects";
    public static final String TYPE = "policies.commands:retrieveSubjects";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;

    private RetrieveSubjects(Label label, String policyId, DittoHeaders dittoHeaders) {
        super(TYPE, dittoHeaders);
        PolicyIdValidator.getInstance().accept((CharSequence)policyId, dittoHeaders);
        this.policyId = policyId;
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
    }

    public static RetrieveSubjects of(String policyId, Label label, DittoHeaders dittoHeaders) {
        return new RetrieveSubjects(label, policyId, dittoHeaders);
    }

    public static RetrieveSubjects fromJson(String jsonString, DittoHeaders dittoHeaders) {
        JsonObject jsonObject = JsonFactory.newObject((String)jsonString);
        return RetrieveSubjects.fromJson(jsonObject, dittoHeaders);
    }

    public static RetrieveSubjects fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrieveSubjects)new CommandJsonDeserializer(TYPE, jsonObject).deserialize(() -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommand.JsonFields.JSON_POLICY_ID);
            Label extractedLabel = Label.of((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            return RetrieveSubjects.of(policyId, extractedLabel, dittoHeaders);
        });
    }

    public Label getLabel() {
        return this.label;
    }

    public String getId() {
        return this.policyId;
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/subjects";
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommand.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
    }

    @Override
    public RetrieveSubjects setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveSubjects.of(this.policyId, this.label, dittoHeaders);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RetrieveSubjects that = (RetrieveSubjects)obj;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && super.equals((Object)that);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrieveSubjects;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + "]";
    }
}

