/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.policies.query;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.policies.Label;
import org.eclipse.ditto.model.policies.PoliciesModelFactory;
import org.eclipse.ditto.model.policies.Subjects;
import org.eclipse.ditto.signals.commands.base.AbstractCommandResponse;
import org.eclipse.ditto.signals.commands.base.CommandResponseJsonDeserializer;
import org.eclipse.ditto.signals.commands.policies.PolicyCommandResponse;
import org.eclipse.ditto.signals.commands.policies.query.PolicyQueryCommandResponse;

@Immutable
public final class RetrieveSubjectsResponse
extends AbstractCommandResponse<RetrieveSubjectsResponse>
implements PolicyQueryCommandResponse<RetrieveSubjectsResponse> {
    public static final String TYPE = "policies.responses:retrieveSubjects";
    static final JsonFieldDefinition<String> JSON_LABEL = JsonFactory.newStringFieldDefinition((CharSequence)"label", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    static final JsonFieldDefinition<JsonObject> JSON_SUBJECTS = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"subjects", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_2});
    private final String policyId;
    private final Label label;
    private final JsonObject subjects;

    private RetrieveSubjectsResponse(String policyId, Label label, JsonObject subjects, HttpStatusCode statusCode, DittoHeaders dittoHeaders) {
        super(TYPE, statusCode, dittoHeaders);
        this.policyId = (String)ConditionChecker.checkNotNull((Object)policyId, (String)"Policy ID");
        this.label = (Label)ConditionChecker.checkNotNull((Object)label, (String)"Label");
        this.subjects = (JsonObject)ConditionChecker.checkNotNull((Object)subjects, (String)"Subjects");
    }

    public static RetrieveSubjectsResponse of(String policyId, Label label, Subjects subjects, DittoHeaders dittoHeaders) {
        return new RetrieveSubjectsResponse(policyId, label, (JsonObject)((Subjects)ConditionChecker.checkNotNull((Object)subjects, (String)"Subjects")).toJson((Predicate)dittoHeaders.getSchemaVersion().orElse(subjects.getLatestSchemaVersion())), HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveSubjectsResponse of(String policyId, Label label, JsonObject subjects, DittoHeaders dittoHeaders) {
        return new RetrieveSubjectsResponse(policyId, label, subjects, HttpStatusCode.OK, dittoHeaders);
    }

    public static RetrieveSubjectsResponse fromJson(String jsonString, DittoHeaders dittoHeaders) {
        return RetrieveSubjectsResponse.fromJson(JsonFactory.newObject((String)jsonString), dittoHeaders);
    }

    public static RetrieveSubjectsResponse fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (RetrieveSubjectsResponse)new CommandResponseJsonDeserializer(TYPE, jsonObject).deserialize(statusCode -> {
            String policyId = (String)jsonObject.getValueOrThrow(PolicyCommandResponse.JsonFields.JSON_POLICY_ID);
            Label label = PoliciesModelFactory.newLabel((CharSequence)((CharSequence)jsonObject.getValueOrThrow(JSON_LABEL)));
            JsonObject extractedSubjects = (JsonObject)jsonObject.getValueOrThrow(JSON_SUBJECTS);
            return RetrieveSubjectsResponse.of(policyId, label, extractedSubjects, dittoHeaders);
        });
    }

    public String getId() {
        return this.policyId;
    }

    public Label getLabel() {
        return this.label;
    }

    public Subjects getSubjects() {
        return PoliciesModelFactory.newSubjects((JsonObject)this.subjects);
    }

    public JsonValue getEntity(JsonSchemaVersion schemaVersion) {
        return this.subjects;
    }

    @Override
    public RetrieveSubjectsResponse setEntity(JsonValue entity) {
        ConditionChecker.checkNotNull((Object)entity, (String)"entity");
        return RetrieveSubjectsResponse.of(this.policyId, this.label, entity.asObject(), this.getDittoHeaders());
    }

    @Override
    public RetrieveSubjectsResponse setDittoHeaders(DittoHeaders dittoHeaders) {
        return RetrieveSubjectsResponse.of(this.policyId, this.label, this.subjects, dittoHeaders);
    }

    public JsonPointer getResourcePath() {
        String path = "/entries/" + this.label + "/subjects";
        return JsonPointer.of((CharSequence)path);
    }

    protected void appendPayload(JsonObjectBuilder jsonObjectBuilder, JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        jsonObjectBuilder.set(PolicyCommandResponse.JsonFields.JSON_POLICY_ID, (Object)this.policyId, predicate);
        jsonObjectBuilder.set(JSON_LABEL, (Object)this.label.toString(), predicate);
        jsonObjectBuilder.set(JSON_SUBJECTS, (Object)this.subjects, predicate);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RetrieveSubjectsResponse;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveSubjectsResponse that = (RetrieveSubjectsResponse)o;
        return that.canEqual(this) && Objects.equals(this.policyId, that.policyId) && Objects.equals(this.label, that.label) && Objects.equals(this.subjects, that.subjects) && super.equals(o);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyId, this.label, this.subjects);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + super.toString() + ", policyId=" + this.policyId + ", label=" + this.label + ", subjects=" + this.subjects + "]";
    }
}

