/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.things;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseOptions;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationContextType;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.model.base.headers.DittoHeaderDefinition;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.policies.PolicyId;
import org.eclipse.ditto.model.things.AccessControlList;
import org.eclipse.ditto.model.things.AclEntry;
import org.eclipse.ditto.model.things.Attributes;
import org.eclipse.ditto.model.things.FeatureDefinition;
import org.eclipse.ditto.model.things.FeatureProperties;
import org.eclipse.ditto.model.things.Features;
import org.eclipse.ditto.model.things.Permission;
import org.eclipse.ditto.model.things.ThingDefinition;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.model.things.ThingLifecycle;
import org.eclipse.ditto.model.things.ThingRevision;
import org.eclipse.ditto.model.things.ThingsModelFactory;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributeNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributeNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributePointerInvalidException;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributesNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.AttributesNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeatureDefinitionNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeatureDefinitionNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeatureNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeatureNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeaturePropertiesNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeaturePropertiesNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeaturePropertyNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeaturePropertyNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeaturesNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.FeaturesNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.MissingThingIdsException;
import org.eclipse.ditto.signals.commands.things.exceptions.PolicyIdNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.PolicyIdNotAllowedException;
import org.eclipse.ditto.signals.commands.things.exceptions.PolicyIdNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.PolicyInvalidException;
import org.eclipse.ditto.signals.commands.things.exceptions.PolicyNotAllowedException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingConflictException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingDefinitionNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingIdNotExplicitlySettableException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingNotAccessibleException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingNotCreatableException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingNotDeletableException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingNotModifiableException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingPreconditionFailedException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingPreconditionNotModifiedException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingTooManyModifyingRequestsException;
import org.eclipse.ditto.signals.commands.things.exceptions.ThingUnavailableException;

public final class TestConstants {
    public static final long THING_SIZE_LIMIT_BYTES = Long.parseLong(System.getProperty("ditto.limits.things.max-size", "-1"));
    public static final String CORRELATION_ID = "a780b7b5-fdd2-4864-91fc-80df6bb0a636";
    public static final DittoHeaders DITTO_HEADERS = DittoHeaders.newBuilder().correlationId((CharSequence)"a780b7b5-fdd2-4864-91fc-80df6bb0a636").authorizationContext(AuthorizationContext.newInstance((AuthorizationContextType)DittoAuthorizationContextType.UNSPECIFIED, (AuthorizationSubject)AuthorizationSubject.newInstance((CharSequence)"the_subject"), (AuthorizationSubject[])new AuthorizationSubject[]{AuthorizationSubject.newInstance((CharSequence)"another_subject")})).build();
    public static final DittoHeaders EMPTY_DITTO_HEADERS = DittoHeaders.empty();
    public static final Instant TIMESTAMP = Instant.EPOCH;
    public static final JsonParseOptions JSON_PARSE_OPTIONS = JsonFactory.newParseOptionsBuilder().withoutUrlDecoding().build();
    public static final JsonFieldSelector JSON_FIELD_SELECTOR_ATTRIBUTES = JsonFactory.newFieldSelector((String)"attributes(location,maker)", (JsonParseOptions)JSON_PARSE_OPTIONS);
    public static final JsonFieldSelector JSON_FIELD_SELECTOR_ATTRIBUTES_WITH_THING_ID = JsonFactory.newFieldSelector((String)"thingId,attributes(location,maker)", (JsonParseOptions)JSON_PARSE_OPTIONS);
    public static final JsonFieldSelector JSON_FIELD_SELECTOR_FEATURE_PROPERTIES = JsonFactory.newFieldSelector((String)"properties/target_year_1", (JsonParseOptions)JSON_PARSE_OPTIONS);

    private TestConstants() {
        throw new AssertionError();
    }

    public static class Pointer {
        public static final JsonPointer EMPTY_JSON_POINTER = JsonFactory.emptyPointer();
        public static final JsonPointer VALID_JSON_POINTER = JsonFactory.newPointer((CharSequence)"properties/foo");
        public static final JsonPointer INVALID_JSON_POINTER = JsonFactory.newPointer((CharSequence)"key1/\u00e4\u00f6\u00fc/foo");
    }

    public static final class Feature {
        public static final String FLUX_CAPACITOR_ID = "FluxCapacitor";
        public static final JsonPointer FLUX_CAPACITOR_PROPERTY_POINTER = JsonFactory.newPointer((CharSequence)"target_year_1");
        public static final JsonValue FLUX_CAPACITOR_PROPERTY_VALUE = JsonFactory.newValue((int)1955);
        public static final FeatureDefinition FLUX_CAPACITOR_DEFINITION = FeatureDefinition.fromIdentifier((CharSequence)"org.eclipse.ditto:fluxcapacitor:1.0.0", (CharSequence[])new CharSequence[0]);
        public static final FeatureProperties FLUX_CAPACITOR_PROPERTIES = ThingsModelFactory.newFeaturePropertiesBuilder().set((CharSequence)"target_year_1", 1955).set((CharSequence)"target_year_2", 2015).set((CharSequence)"target_year_3", 1885).build();
        public static final org.eclipse.ditto.model.things.Feature FLUX_CAPACITOR = ThingsModelFactory.newFeatureBuilder().properties(FLUX_CAPACITOR_PROPERTIES).withId("FluxCapacitor").build();
        public static final Features FEATURES = ThingsModelFactory.newFeatures((org.eclipse.ditto.model.things.Feature)FLUX_CAPACITOR, (org.eclipse.ditto.model.things.Feature[])new org.eclipse.ditto.model.things.Feature[0]);
        public static final FeaturesNotAccessibleException FEATURES_NOT_ACCESSIBLE_EXCEPTION = (FeaturesNotAccessibleException)FeaturesNotAccessibleException.newBuilder((ThingId)Thing.THING_ID).build();
        public static final FeaturesNotModifiableException FEATURES_NOT_MODIFIABLE_EXCEPTION = (FeaturesNotModifiableException)FeaturesNotModifiableException.newBuilder((ThingId)Thing.THING_ID).build();
        public static final FeatureNotAccessibleException FEATURE_NOT_ACCESSIBLE_EXCEPTION = (FeatureNotAccessibleException)FeatureNotAccessibleException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor").build();
        public static final FeatureNotModifiableException FEATURE_NOT_MODIFIABLE_EXCEPTION = (FeatureNotModifiableException)FeatureNotModifiableException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor").build();
        public static final FeatureDefinitionNotAccessibleException FEATURE_DEFINITION_NOT_ACCESSIBLE_EXCEPTION = (FeatureDefinitionNotAccessibleException)FeatureDefinitionNotAccessibleException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor").build();
        public static final FeatureDefinitionNotModifiableException FEATURE_DEFINITION_NOT_MODIFIABLE_EXCEPTION = (FeatureDefinitionNotModifiableException)FeatureDefinitionNotModifiableException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor").build();
        public static final FeaturePropertiesNotAccessibleException FEATURE_PROPERTIES_NOT_ACCESSIBLE_EXCEPTION = (FeaturePropertiesNotAccessibleException)FeaturePropertiesNotAccessibleException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor").build();
        public static final FeaturePropertiesNotModifiableException FEATURE_PROPERTIES_NOT_MODIFIABLE_EXCEPTION = (FeaturePropertiesNotModifiableException)FeaturePropertiesNotModifiableException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor").build();
        public static final FeaturePropertyNotAccessibleException FEATURE_PROPERTY_NOT_ACCESSIBLE_EXCEPTION = (FeaturePropertyNotAccessibleException)FeaturePropertyNotAccessibleException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor", (JsonPointer)FLUX_CAPACITOR_PROPERTY_POINTER).build();
        public static final FeaturePropertyNotModifiableException FEATURE_PROPERTY_NOT_MODIFIABLE_EXCEPTION = (FeaturePropertyNotModifiableException)FeaturePropertyNotModifiableException.newBuilder((ThingId)Thing.THING_ID, (String)"FluxCapacitor", (JsonPointer)FLUX_CAPACITOR_PROPERTY_POINTER).build();

        private Feature() {
            throw new AssertionError();
        }
    }

    public static final class Thing {
        public static final ThingId THING_ID = ThingId.of((String)"example.com", (String)"testThing");
        public static final PolicyId POLICY_ID = PolicyId.of((CharSequence)"example.com:testPolicy");
        public static final ThingDefinition DEFINITION = ThingsModelFactory.newDefinition((CharSequence)"example:test:definition");
        public static final ThingLifecycle LIFECYCLE = ThingLifecycle.ACTIVE;
        public static final AccessControlList ACL = ThingsModelFactory.newAcl((AclEntry)Authorization.ACL_ENTRY_OLDMAN, (AclEntry[])new AclEntry[]{Authorization.ACL_ENTRY_GRIMES});
        public static final JsonPointer LOCATION_ATTRIBUTE_POINTER = JsonFactory.newPointer((CharSequence)"location");
        public static final JsonObject LOCATION_ATTRIBUTE_VALUE = JsonFactory.newObjectBuilder().set((CharSequence)"latitude", 44.673856).set((CharSequence)"longitude", 8.261719).build();
        public static final Attributes ATTRIBUTES = ThingsModelFactory.newAttributesBuilder().set((CharSequence)LOCATION_ATTRIBUTE_POINTER, (JsonValue)LOCATION_ATTRIBUTE_VALUE).set((CharSequence)"maker", "Bosch").build();
        public static final long REVISION_NUMBER = 0L;
        public static final ThingRevision REVISION = ThingsModelFactory.newThingRevision((long)0L);
        public static final org.eclipse.ditto.model.things.Thing THING = ThingsModelFactory.newThingBuilder().setId(THING_ID).setAttributes(ATTRIBUTES).setDefinition(DEFINITION).setFeatures((Iterable)Feature.FEATURES).setLifecycle(LIFECYCLE).setPolicyId(POLICY_ID).build();
        public static final ThingConflictException THING_CONFLICT_EXCEPTION = (ThingConflictException)ThingConflictException.newBuilder((ThingId)THING_ID).build();
        public static final ThingIdNotExplicitlySettableException THING_ID_NOT_EXPLICITLY_SETTABLE_EXCEPTION = (ThingIdNotExplicitlySettableException)ThingIdNotExplicitlySettableException.forPostMethod().build();
        public static final ThingPreconditionFailedException THING_PRECONDITION_FAILED_EXCEPTION = (ThingPreconditionFailedException)ThingPreconditionFailedException.newBuilder((String)DittoHeaderDefinition.IF_MATCH.getKey(), (String)"\"rev:1\"", (String)"\"rev:2\"").build();
        public static final ThingPreconditionNotModifiedException THING_PRECONDITION_NOT_MODIFIED_EXCEPTION = (ThingPreconditionNotModifiedException)ThingPreconditionNotModifiedException.newBuilder((String)"\"rev:1\"", (String)"*").build();
        public static final ThingNotAccessibleException THING_NOT_ACCESSIBLE_EXCEPTION = (ThingNotAccessibleException)ThingNotAccessibleException.newBuilder((ThingId)THING_ID).build();
        public static final ThingNotDeletableException THING_NOT_DELETABLE_EXCEPTION = (ThingNotDeletableException)ThingNotDeletableException.newBuilder((ThingId)THING_ID).build();
        public static final ThingNotCreatableException THING_NOT_CREATABLE_EXCEPTION = (ThingNotCreatableException)ThingNotCreatableException.newBuilderForPolicyMissing((ThingId)THING_ID, (PolicyId)POLICY_ID).build();
        public static final ThingNotModifiableException THING_NOT_MODIFIABLE_EXCEPTION = (ThingNotModifiableException)ThingNotModifiableException.newBuilder((ThingId)THING_ID).build();
        public static final PolicyIdNotModifiableException POLICY_ID_NOT_MODIFIABLE_EXCEPTION = (PolicyIdNotModifiableException)PolicyIdNotModifiableException.newBuilder((ThingId)THING_ID).build();
        public static final PolicyIdNotAllowedException POLICY_ID_NOT_ALLOWED_EXCEPTION = (PolicyIdNotAllowedException)PolicyIdNotAllowedException.newBuilder((ThingId)THING_ID).build();
        public static final PolicyNotAllowedException POLICY_NOT_ALLOWED_EXCEPTION = (PolicyNotAllowedException)PolicyNotAllowedException.newBuilder((ThingId)THING_ID).build();
        public static final PolicyIdNotAccessibleException POLICY_ID_NOT_ACCESSIBLE_EXCEPTION = (PolicyIdNotAccessibleException)PolicyIdNotAccessibleException.newBuilder((ThingId)THING_ID).build();
        public static final ThingDefinitionNotAccessibleException THING_DEFINITION_NOT_ACCESSIBLE_EXCEPTION = (ThingDefinitionNotAccessibleException)ThingDefinitionNotAccessibleException.newBuilder((ThingId)THING_ID).build();
        public static final AttributesNotAccessibleException ATTRIBUTES_NOT_ACCESSIBLE_EXCEPTION = (AttributesNotAccessibleException)AttributesNotAccessibleException.newBuilder((ThingId)THING_ID).build();
        public static final AttributesNotModifiableException ATTRIBUTES_NOT_MODIFIABLE_EXCEPTION = (AttributesNotModifiableException)AttributesNotModifiableException.newBuilder((ThingId)THING_ID).build();
        public static final AttributeNotAccessibleException ATTRIBUTE_NOT_ACCESSIBLE_EXCEPTION = (AttributeNotAccessibleException)AttributeNotAccessibleException.newBuilder((ThingId)THING_ID, (JsonPointer)LOCATION_ATTRIBUTE_POINTER).build();
        public static final AttributeNotModifiableException ATTRIBUTE_NOT_MODIFIABLE_EXCEPTION = (AttributeNotModifiableException)AttributeNotModifiableException.newBuilder((ThingId)THING_ID, (JsonPointer)LOCATION_ATTRIBUTE_POINTER).build();
        public static final AttributePointerInvalidException ATTRIBUTE_POINTER_INVALID_EXCEPTION = (AttributePointerInvalidException)AttributePointerInvalidException.newBuilder((JsonPointer)LOCATION_ATTRIBUTE_POINTER).build();
        public static final ThingUnavailableException THING_UNAVAILABLE_EXCEPTION = (ThingUnavailableException)ThingUnavailableException.newBuilder((ThingId)THING_ID).build();
        public static final ThingTooManyModifyingRequestsException THING_TOO_MANY_MODIFYING_REQUESTS_EXCEPTION = (ThingTooManyModifyingRequestsException)ThingTooManyModifyingRequestsException.newBuilder((ThingId)THING_ID).build();
        public static final MissingThingIdsException MISSING_THING_IDS_EXCEPTION = (MissingThingIdsException)MissingThingIdsException.newBuilder().build();
        public static Collection<String> REQUIRED_THING_PERMISSIONS = Arrays.asList("READ", "WRITE");
        public static final PolicyInvalidException POLICY_INVALID_EXCEPTION = (PolicyInvalidException)PolicyInvalidException.newBuilder(REQUIRED_THING_PERMISSIONS, (ThingId)THING_ID).build();

        private Thing() {
            throw new AssertionError();
        }
    }

    public static final class Authorization {
        public static final AuthorizationSubject AUTH_SUBJECT_OLDMAN = AuthorizationModelFactory.newAuthSubject((CharSequence)"JohnOldman");
        public static final AuthorizationSubject AUTH_SUBJECT_GRIMES = AuthorizationModelFactory.newAuthSubject((CharSequence)"FrankGrimes");
        public static final AuthorizationContext AUTH_CONTEXT = AuthorizationModelFactory.newAuthContext((AuthorizationContextType)DittoAuthorizationContextType.UNSPECIFIED, (AuthorizationSubject)AUTH_SUBJECT_OLDMAN, (AuthorizationSubject[])new AuthorizationSubject[]{AUTH_SUBJECT_GRIMES});
        public static final List<AuthorizationSubject> AUTHORIZATION_SUBJECTS = Arrays.asList(AUTH_SUBJECT_OLDMAN, AUTH_SUBJECT_GRIMES);
        public static final AclEntry ACL_ENTRY_OLDMAN = ThingsModelFactory.newAclEntry((AuthorizationSubject)AUTH_SUBJECT_OLDMAN, (Permission)Permission.READ, (Permission[])new Permission[]{Permission.WRITE, Permission.ADMINISTRATE});
        public static final AclEntry ACL_ENTRY_GRIMES = ThingsModelFactory.newAclEntry((AuthorizationSubject)AUTH_SUBJECT_GRIMES, (Permission)Permission.READ, (Permission[])new Permission[0]);

        private Authorization() {
            throw new AssertionError();
        }
    }
}

