/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.things.assertions;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.signals.commands.base.assertions.AbstractCommandAssert;
import org.eclipse.ditto.signals.commands.things.assertions.AbstractThingCommandAssert;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommand;

public abstract class AbstractThingModifyCommandAssert<S extends AbstractThingModifyCommandAssert<S, C>, C extends ThingModifyCommand>
extends AbstractThingCommandAssert<S, C> {
    protected AbstractThingModifyCommandAssert(C actual, Class<? extends AbstractCommandAssert> selfType) {
        super(actual, selfType);
    }

    public S withEntity(JsonValue expectedEntity) {
        this.isNotNull();
        Optional actualEntity = ((ThingModifyCommand)this.actual).getEntity();
        if (null != expectedEntity) {
            ((OptionalAssert)Assertions.assertThat((Optional)actualEntity).overridingErrorMessage("Expected Command to have entity\n<%s> but it had\n<%s>", new Object[]{expectedEntity, actualEntity.orElse(null)})).contains((Object)expectedEntity);
            return (S)((Object)((AbstractThingModifyCommandAssert)this.myself));
        }
        return this.withoutEntity();
    }

    public S withoutEntity() {
        this.isNotNull();
        Optional actualEntity = ((ThingModifyCommand)this.actual).getEntity();
        ((OptionalAssert)Assertions.assertThat((Optional)actualEntity).overridingErrorMessage("Expected Command not to have an entity but it had\n<%s>", new Object[]{actualEntity.orElse(null)})).isEmpty();
        return (S)((Object)((AbstractThingModifyCommandAssert)this.myself));
    }
}

